/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui.renderer;

import dev.imb11.skinshuffle.client.SkinShuffleClient;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.gui.renderer.GuiEntityRenderer;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3673;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SkinPreviewRenderer {
    private final class_310 client;

    public SkinPreviewRenderer(class_310 client) {
        this.client = client;
    }

    public void renderPreviewArea(class_332 graphics, int previewCenterX, int previewCenterY, int previewSpanX, int previewSpanY) {
        graphics.method_49601(previewCenterX - previewSpanX, previewCenterY - previewSpanY, previewSpanX * 2, previewSpanY * 2, -553648128);
        graphics.method_25294(previewCenterX - previewSpanX + 1, previewCenterY - previewSpanY + 1, previewCenterX + previewSpanX - 1, previewCenterY + previewSpanY - 1, 0x7F000000);
    }

    public void renderSkinPreview(class_332 graphics, SkinPreset preset, int mouseX, int mouseY, int previewCenterX, int previewCenterY, int previewSpanY, SkinShuffleConfig.SkinRenderStyle renderStyle, boolean isLoading) {
        if (preset.getSkin().isLoading() || isLoading) {
            this.renderLoadingIndicator(graphics, previewCenterX, previewCenterY);
            if (preset.getSkin().isLoading()) {
                preset.getSkin().getTexture();
            }
            return;
        }
        int entityX = previewCenterX;
        int entityY = previewCenterY + previewSpanY / 10 * 8 + 30;
        float followX = entityX - mouseX;
        float followY = (float)entityY - (float)previewSpanY * 1.2f - (float)mouseY - 10.0f;
        float rotation = 0.0f;
        if (renderStyle.equals((Object)SkinShuffleConfig.SkinRenderStyle.ROTATION)) {
            followX = 0.0f;
            followY = 0.0f;
            rotation = SkinPreviewRenderer.getEntityRotation() * SkinShuffleConfig.get().rotationMultiplier;
        }
        graphics.method_51448().method_22903();
        GuiEntityRenderer.drawEntity(graphics.method_51448(), entityX, entityY, previewSpanY / 10 * 8, rotation, followX, followY, preset.getSkin(), renderStyle);
        graphics.method_51448().method_22909();
    }

    public void renderLoadingIndicator(class_332 graphics, int centerX, int centerY) {
        class_327 textRenderer = this.client.field_1772;
        class_5250 txt = class_2561.method_43471((String)"skinshuffle.edit.loading");
        int textWidth = textRenderer.method_27525((class_5348)txt);
        float totalDeltaTick = SkinShuffleClient.TOTAL_TICK_DELTA * 5.0f;
        float hue = totalDeltaTick % 360.0f / 360.0f;
        float saturation = 0.75f;
        float lightness = 1.0f;
        int color = Color.HSBtoRGB(hue, saturation, lightness);
        color = color & 0xFFFFFF | 0xFF000000;
        int n = centerX - textWidth / 2;
        Objects.requireNonNull(textRenderer);
        graphics.method_27535(textRenderer, (class_2561)txt, n, centerY - 9, color);
    }

    public static float getEntityRotation() {
        return (float)class_3673.method_15974() * 35.0f;
    }
}

