/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui.widgets.presets;

import dev.imb11.skinshuffle.client.config.SkinPresetManager;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.gui.PresetEditScreen;
import dev.imb11.skinshuffle.client.gui.carousels.CarouselScreen;
import dev.imb11.skinshuffle.client.gui.carousels.CompactCarouselScreen;
import dev.imb11.skinshuffle.client.gui.renderer.GuiEntityRenderer;
import dev.imb11.skinshuffle.client.gui.widgets.buttons.VariableButton;
import dev.imb11.skinshuffle.client.gui.widgets.presets.AbstractCardWidget;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3673;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_8030;

public abstract class PresetWidget<S extends CarouselScreen>
extends AbstractCardWidget<S> {
    protected final SkinPreset skinPreset;
    private final boolean showButtons;
    protected VariableButton editButton;
    protected VariableButton copyButton;
    protected VariableButton deleteButton;
    protected double scaleFactor;

    public PresetWidget(S parent, SkinPreset skinPreset) {
        super(Position.of((int)0, (int)0), ((CarouselScreen)((Object)parent)).getCardWidth(), ((CarouselScreen)((Object)parent)).getCardHeight(), parent);
        this.skinPreset = skinPreset;
        this.skinPreset.getSkin().getTexture();
        this.showButtons = true;
        if (this.showButtons) {
            this.editButton = new VariableButton(Position.of((int)0, (int)0), 0, 0, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.preset_widget.edit"), button -> this.client.method_1507((class_437)new PresetEditScreen(this, this.parent, this.skinPreset)));
            this.copyButton = new VariableButton(Position.of((int)0, (int)0), 0, 0, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.preset_widget.copy"), button -> {
                SkinPreset presetCopy = this.skinPreset.copy();
                presetCopy.setName(this.skinPreset.getName() + " (Copy)");
                SkinPresetManager.addPreset(presetCopy);
                this.parent.refresh();
            });
            this.deleteButton = new VariableButton(Position.of((int)0, (int)0), 0, 0, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.preset_widget.delete"), button -> {
                class_410 confirmScreen = new class_410(result -> {
                    if (result) {
                        SkinPresetManager.deletePreset(this.skinPreset);
                    }
                    this.parent.refresh();
                    this.client.method_1507((class_437)this.parent);
                }, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.confirmations.delete_preset.title"), (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.confirmations.delete_preset.message"));
                this.client.method_1507((class_437)confirmScreen);
            });
            if (SkinPresetManager.getLoadedPresets().size() < 2) {
                this.deleteButton.setActive(false);
            }
            this.addChild((SpruceWidget)this.deleteButton);
            this.addChild((SpruceWidget)this.editButton);
            this.addChild((SpruceWidget)this.copyButton);
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        for (SpruceWidget child : this.children()) {
            if (child.equals((Object)this.deleteButton) && SkinPresetManager.getLoadedPresets().size() < 2) continue;
            child.setActive(active);
        }
    }

    protected void renderBackground(class_332 graphics, int mouseX, int mouseY, float delta) {
        int borderColour;
        int n = borderColour = this.active ? -553648128 : 0x5F000000;
        if (SkinPresetManager.getChosenPreset().equals(this.skinPreset)) {
            borderColour = this.active ? -553609473 : 1593874175;
        } else if (SkinPresetManager.getApiPreset() != null && SkinPresetManager.getApiPreset().equals(this.skinPreset)) {
            borderColour = this.active ? -553582848 : 0x5F00FF00;
        }
        graphics.method_49601(this.getX(), this.getY(), this.getWidth(), this.getHeight(), borderColour);
        graphics.method_25294(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, this.active ? 0x7F000000 : 0xD000000);
    }

    protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        Objects.requireNonNull(this.client.field_1772);
        int margin = 9 / 2;
        String name = this.skinPreset.getName() != null ? this.skinPreset.getName() : "Unnamed Preset";
        int nameWidth = this.client.field_1772.method_1727(name);
        int halfWidth = this.width / 2;
        int halfNameWidth = nameWidth / 2;
        class_327 class_3272 = this.client.field_1772;
        class_2561 class_25612 = class_2561.method_30163((String)name);
        int n = this.getX() + halfWidth - Math.min(halfWidth - margin, halfNameWidth);
        int n2 = this.getY() + margin;
        int n3 = this.getX() + halfWidth + Math.min(halfWidth - margin, halfNameWidth);
        int n4 = this.getY() + margin;
        Objects.requireNonNull(this.client.field_1772);
        class_339.method_52718((class_332)graphics, (class_327)class_3272, (class_2561)class_25612, (int)n, (int)n2, (int)n3, (int)(n4 + 9), (int)(this.active ? -1 : -8355712));
        int previewX = this.getPreviewX();
        int previewY = this.getPreviewY();
        float followX = (float)previewX - (float)mouseX;
        float followY = (float)(previewY - this.height / 40 * 16) - (float)mouseY - 20.0f;
        float rotation = 0.0f;
        SkinShuffleConfig.SkinRenderStyle renderStyle = SkinShuffleConfig.get().carouselSkinRenderStyle;
        if (renderStyle.equals((Object)SkinShuffleConfig.SkinRenderStyle.ROTATION)) {
            followX = 0.0f;
            followY = 0.0f;
            rotation = this.getEntityRotation() * SkinShuffleConfig.get().rotationMultiplier;
        }
        if (!this.active) {
            followX = 0.0f;
            followY = 0.0f;
            rotation = 0.0f;
        }
        if (!this.skinPreset.getSkin().isLoading()) {
            if (renderStyle.equals((Object)SkinShuffleConfig.SkinRenderStyle.CURSOR) && this.method_25405(mouseX, mouseY)) {
                rotation = (float)(class_3673.method_15974() - (this.parent != null && !(this.parent instanceof CompactCarouselScreen) ? this.parent.getLastCardSwitchTime() : 0.0)) * 35.0f * SkinShuffleConfig.get().rotationMultiplier;
                followX = 0.0f;
                followY = 0.0f;
            }
            graphics.method_51448().method_22903();
            GuiEntityRenderer.drawEntity(graphics.method_51448(), previewX, previewY, this.getPreviewSize(), rotation, followX, followY, this.skinPreset.getSkin(), renderStyle);
            graphics.method_51448().method_22909();
        }
    }

    protected int getPreviewX() {
        return this.getX() + this.getWidth() / 2;
    }

    protected int getPreviewY() {
        return (int)((double)this.getY() + (this.showButtons ? (double)this.height / 1.6 : (double)this.height * 0.75)) + 20;
    }

    protected int getPreviewSize() {
        return this.height / 4;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    private float getEntityRotation() {
        return this.active && SkinShuffleConfig.get().carouselSkinRenderStyle.equals((Object)SkinShuffleConfig.SkinRenderStyle.ROTATION) ? (float)(class_3673.method_15974() - (this.parent != null && !(this.parent instanceof CompactCarouselScreen) ? this.parent.getLastCardSwitchTime() : 0.0)) * 35.0f : 0.0f;
    }

    public SkinPreset getPreset() {
        return this.skinPreset;
    }

    public class_8030 method_48202() {
        return super.method_48202();
    }

    @Override
    public void refreshState() {
        super.refreshState();
    }

    @Override
    public boolean isMovable() {
        return true;
    }
}

