/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.util;

import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.client.config.SkinPresetManager;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.gui.GeneratedScreens;
import dev.imb11.skinshuffle.networking.ClientSkinHandling;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;

public class KeybindManager {
    private static final int MAX_KEYBIND_COUNT = 9;
    private static final String TRANSLATION_KEY_PREFIX = "key.skinshuffle.preset_";
    private static final String KEYBIND_CATEGORY = "category.skinshuffle.presets";
    private static class_304[] presetKeybindings;

    public static void init() {
        presetKeybindings = new class_304[9];
        for (int i = 0; i < 9; ++i) {
            int presetId = i + 1;
            KeybindManager.presetKeybindings[i] = KeyBindingHelper.registerKeyBinding((class_304)new class_304(TRANSLATION_KEY_PREFIX + presetId, class_3675.class_307.field_1668, -1, KEYBIND_CATEGORY));
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                KeybindManager.checkKeybindings(client);
            }
        });
    }

    private static void checkKeybindings(class_310 client) {
        for (int i = 0; i < presetKeybindings.length; ++i) {
            if (!presetKeybindings[i].method_1436()) continue;
            int presetId = i + 1;
            KeybindManager.applyPreset(presetId, client);
        }
    }

    private static void applyPreset(int presetId, class_310 client) {
        if (SkinPresetManager.getChosenPreset().getKeybindId() == presetId) {
            return;
        }
        boolean success = SkinPresetManager.applyPresetByKeybindId(presetId);
        if (success) {
            SkinShuffle.LOGGER.info("Applied skin preset with keybind ID: " + presetId);
            if (client.field_1687 != null && !ClientSkinHandling.isInstalledOnServer()) {
                client.method_1507(GeneratedScreens.getReconnectScreen(client.field_1755));
            } else if (SkinShuffleConfig.get().playKeybindSoundEffect && client.field_1724 != null) {
                client.field_1724.method_17356(class_3417.field_14561, class_3419.field_15250, 0.46f, 2.0f);
            }
        }
    }
}

