/*
 * Decompiled with CFR 0.152.
 */
package com.atl.vitalstats.core;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1309;

public class HealthTracker {
    private static final ConcurrentHashMap<UUID, HealthData> trackedEntities = new ConcurrentHashMap();

    public static void addEntity(class_1309 entity) {
        trackedEntities.put(entity.method_5667(), new HealthData(entity));
    }

    public static void removeEntity(UUID entityId) {
        trackedEntities.remove(entityId);
    }

    public static boolean isTracked(class_1309 entity) {
        return trackedEntities.containsKey(entity.method_5667());
    }

    public static void updateHealth(class_1309 entity) {
        HealthData data = trackedEntities.get(entity.method_5667());
        if (data != null) {
            data.updateHealth(entity);
        }
    }

    public static void cleanup() {
        trackedEntities.entrySet().removeIf(entry -> ((HealthData)entry.getValue()).shouldRemove());
    }

    private static class HealthData {
        private float lastHealth;
        private float lastMaxHealth;
        private long lastUpdate;

        public HealthData(class_1309 entity) {
            this.lastHealth = entity.method_6032();
            this.lastMaxHealth = entity.method_6063();
            this.lastUpdate = System.currentTimeMillis();
        }

        public void updateHealth(class_1309 entity) {
            this.lastHealth = entity.method_6032();
            this.lastMaxHealth = entity.method_6063();
            this.lastUpdate = System.currentTimeMillis();
        }

        public boolean shouldRemove() {
            return System.currentTimeMillis() - this.lastUpdate > 60000L;
        }
    }
}

