/*
 * Decompiled with CFR 0.152.
 */
package com.atl.vitalstats.core;

import com.atl.vitalstats.VitalStatsCommon;
import com.atl.vitalstats.config.VitalStatsConfig;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;

public class TotemTracker {
    private static final ConcurrentHashMap<UUID, TotemData> trackedPlayers = new ConcurrentHashMap();

    public static void addTotemPop(class_1657 player) {
        TotemData data;
        UUID playerId = player.method_5667();
        String playerName = player.method_5820();
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.info("\ud83d\udfe2 TOTEM POP DETECTED for player: {} (UUID: {})", (Object)playerName, (Object)playerId);
        }
        if ((data = trackedPlayers.get(playerId)) == null) {
            data = new TotemData();
            trackedPlayers.put(playerId, data);
            if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
                VitalStatsCommon.LOGGER.info("\ud83d\udcdd Created new totem data for player: {}", (Object)playerName);
            }
        }
        int oldCount = data.getCount();
        data.incrementCount();
        int newCount = data.getCount();
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.info("\ud83d\udd22 Totem count for {}: {} -> {} (Total tracked players: {})", new Object[]{playerName, oldCount, newCount, trackedPlayers.size()});
        }
    }

    public static int getTotemCount(class_1657 player) {
        int count;
        TotemData data = trackedPlayers.get(player.method_5667());
        int n = count = data != null ? data.getCount() : 0;
        if (count > 0 && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.debug("\ud83d\udcca Returning totem count {} for player: {}", (Object)count, (Object)player.method_5820());
        }
        return count;
    }

    public static boolean hasTotemPops(class_1657 player) {
        boolean hasPops;
        boolean bl = hasPops = TotemTracker.getTotemCount(player) > 0;
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.debug("\u2753 hasTotemPops for {}: {}", (Object)player.method_5820(), (Object)hasPops);
        }
        return hasPops;
    }

    public static void resetTotemCount(class_1657 player) {
        UUID playerId = player.method_5667();
        TotemData removed = trackedPlayers.remove(playerId);
        if (removed != null && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.info("\ud83d\udd04 Reset totem count for player: {} (was: {})", (Object)player.method_5820(), (Object)removed.getCount());
        }
    }

    public static void resetAllTotemCounts() {
        int count = trackedPlayers.size();
        trackedPlayers.clear();
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.info("\ud83e\uddf9 Reset ALL totem counts ({} players cleared)", (Object)count);
        }
    }

    public static void resetTotemCountsForWorld() {
        int count = trackedPlayers.size();
        trackedPlayers.clear();
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.info("\ud83c\udf0d Reset totem counts for world change ({} players cleared)", (Object)count);
        }
    }

    public static void cleanup() {
        long currentTime = System.currentTimeMillis();
        int sizeBefore = trackedPlayers.size();
        trackedPlayers.entrySet().removeIf(entry -> currentTime - ((TotemData)entry.getValue()).getLastUpdate() > 600000L);
        int sizeAfter = trackedPlayers.size();
        if (sizeBefore != sizeAfter && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).enable_debug_logging) {
            VitalStatsCommon.LOGGER.info("\ud83e\uddfd Cleanup removed {} old totem entries ({} -> {})", new Object[]{sizeBefore - sizeAfter, sizeBefore, sizeAfter});
        }
    }

    private static class TotemData {
        private int count = 0;
        private long lastUpdate = System.currentTimeMillis();

        public void incrementCount() {
            ++this.count;
            this.lastUpdate = System.currentTimeMillis();
        }

        public int getCount() {
            return this.count;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }
    }
}

