/*
 * Decompiled with CFR 0.152.
 */
package com.atl.vitalstats.mixin.client;

import com.atl.vitalstats.client.render.RenderTracker;
import com.atl.vitalstats.config.Config;
import com.atl.vitalstats.config.VitalStatsConfig;
import com.atl.vitalstats.core.TotemTracker;
import com.atl.vitalstats.enums.HealthDisplayTypeEnum;
import com.atl.vitalstats.enums.HeartTypeEnum;
import com.atl.vitalstats.enums.TotemTypeEnum;
import com.atl.vitalstats.util.render.HeartJumpData;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_757;
import net.minecraft.class_8646;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public abstract class EntityRendererMixin<T extends class_1309, M extends class_583<T>>
extends class_897<T>
implements class_3883<T, M> {
    @Unique
    private final class_310 client = class_310.method_1551();

    protected EntityRendererMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    public void render(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo ci) {
        if ((RenderTracker.isInUUIDS(livingEntity) || Config.getOverrideAllFiltersEnabled() && !RenderTracker.isInvalid(livingEntity)) && (Config.getHeartsRenderingEnabled() || Config.getOverrideAllFiltersEnabled())) {
            if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS) {
                this.renderHearts(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            } else if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.NUMBER) {
                this.renderNumber(livingEntity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
            }
        }
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).show_totem_counter) {
                boolean shouldShow = false;
                if (player == this.client.field_1724 && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).show_for_self) {
                    shouldShow = true;
                } else if (player != this.client.field_1724 && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).show_for_other_players) {
                    shouldShow = true;
                }
                if (shouldShow) {
                    this.renderTotemCounter(player, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
                }
            }
        }
    }

    @Unique
    private void renderHearts(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_289 tessellator = class_289.method_1348();
        double d = this.field_4676.method_23168(livingEntity);
        int healthRed = class_3532.method_15386((float)livingEntity.method_6032());
        int maxHealth = class_3532.method_15386((float)livingEntity.method_6063());
        int healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).percentage_based_health) {
            healthRed = class_3532.method_15386((float)((float)healthRed / (float)maxHealth * (float)((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).max_health));
            maxHealth = class_3532.method_15386((float)((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).max_health);
            healthYellow = class_3532.method_15386((float)livingEntity.method_6067());
        }
        int heartsRed = class_3532.method_15386((float)((float)healthRed / 2.0f));
        boolean lastRedHalf = (healthRed & 1) == 1;
        int heartsNormal = class_3532.method_15386((float)((float)maxHealth / 2.0f));
        int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
        boolean lastYellowHalf = (healthYellow & 1) == 1;
        int heartsTotal = heartsNormal + heartsYellow;
        int heartsPerRow = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).icons_per_row;
        int pixelsTotal = Math.min(heartsTotal, heartsPerRow) * 8 + 1;
        float maxX = (float)pixelsTotal / 2.0f;
        double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsTotal / (double)heartsPerRow), -3.0) * 5.0;
        double h = 0.0;
        for (int isDrawingEmpty = 0; isDrawingEmpty < 2; ++isDrawingEmpty) {
            for (int heart = 0; heart < heartsTotal; ++heart) {
                if (heart % heartsPerRow == 0) {
                    h = (double)heart / heartDensity;
                }
                matrixStack.method_22903();
                float scale = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).size;
                class_287 vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                matrixStack.method_22904(0.0, (double)(livingEntity.method_17682() + 0.5f) + h, 0.0);
                if (livingEntity.method_6059(class_1294.field_5924) && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).show_heart_effects && HeartJumpData.getWhichHeartJumping(livingEntity) == heart) {
                    matrixStack.method_22904(0.0, (double)(1.15f * scale), 0.0);
                }
                if ((this.method_3921((class_1297)livingEntity) || ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                matrixStack.method_22907(this.field_4676.method_24197());
                matrixStack.method_22905(-scale, scale, scale);
                matrixStack.method_22904(0.0, ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).display_offset, 0.0);
                Matrix4f model = matrixStack.method_23760().method_23761();
                float x = maxX - (float)(heart % heartsPerRow * 8);
                if (isDrawingEmpty == 0) {
                    EntityRendererMixin.drawHeart(model, (class_4588)vertexConsumer, x, HeartTypeEnum.EMPTY, livingEntity);
                } else {
                    HeartTypeEnum type;
                    if (heart < heartsRed) {
                        type = HeartTypeEnum.RED_FULL;
                        if (heart == heartsRed - 1 && lastRedHalf) {
                            type = HeartTypeEnum.RED_HALF;
                        }
                    } else if (heart < heartsNormal) {
                        type = HeartTypeEnum.EMPTY;
                    } else {
                        type = HeartTypeEnum.YELLOW_FULL;
                        if (heart == heartsTotal - 1 && lastYellowHalf) {
                            type = HeartTypeEnum.YELLOW_HALF;
                        }
                    }
                    if (type != HeartTypeEnum.EMPTY) {
                        EntityRendererMixin.drawHeart(model, (class_4588)vertexConsumer, x, type, livingEntity);
                    }
                }
                try {
                    class_9801 builtBuffer = vertexConsumer.method_60794();
                    if (builtBuffer != null) {
                        class_286.method_43433((class_9801)builtBuffer);
                        builtBuffer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                matrixStack.method_22909();
            }
        }
    }

    @Unique
    private void renderNumber(T livingEntity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        Matrix4f model;
        String healthText;
        double d = this.field_4676.method_23168(livingEntity);
        float health = livingEntity.method_6032();
        float maxHealth = livingEntity.method_6063();
        float absorption = livingEntity.method_6067();
        if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).percentage_based_health) {
            float percentage = health / maxHealth * 100.0f;
            healthText = String.format("%.0f%%", Float.valueOf(percentage));
        } else {
            healthText = String.format("%.0f", Float.valueOf(health));
        }
        matrixStack.method_22903();
        float scale = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).size;
        matrixStack.method_46416(0.0f, livingEntity.method_17682() + 0.5f, 0.0f);
        if ((this.method_3921((class_1297)livingEntity) || ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).force_higher_offset_for_players && livingEntity instanceof class_1657 && livingEntity != this.client.field_1724) && d <= 4096.0) {
            matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            if (d < 100.0 && livingEntity instanceof class_1657 && livingEntity.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
            }
        }
        matrixStack.method_22907(this.field_4676.method_24197());
        if (!((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).percentage_based_health) {
            matrixStack.method_22903();
            matrixStack.method_22905(-scale, scale, scale);
            matrixStack.method_22904(0.0, ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).display_offset, 0.0);
            class_289 tessellator = class_289.method_1348();
            class_287 vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            model = matrixStack.method_23760().method_23761();
            class_327 textRenderer = class_310.method_1551().field_1772;
            float textWidth = textRenderer.method_1727(healthText);
            float heartIconX = -1.5f;
            float heartIconY = 1.0f;
            HeartTypeEnum heartType = HeartTypeEnum.RED_FULL;
            if (absorption > 0.0f) {
                heartType = HeartTypeEnum.YELLOW_FULL;
            }
            EntityRendererMixin.drawHeartWithOffset(model, (class_4588)vertexConsumer, heartIconX, heartIconY, heartType, livingEntity);
            try {
                class_9801 builtBuffer = vertexConsumer.method_60794();
                if (builtBuffer != null) {
                    class_286.method_43433((class_9801)builtBuffer);
                    builtBuffer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            matrixStack.method_22909();
        }
        matrixStack.method_22905(scale, -scale, scale);
        matrixStack.method_22904(0.0, -((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).display_offset, 0.0);
        class_327 textRenderer = class_310.method_1551().field_1772;
        float x = (float)(-textRenderer.method_1727(healthText)) / 1.3f;
        model = matrixStack.method_23760().method_23761();
        textRenderer.method_27521(healthText, x, 0.0f, ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).number_color.getRGB(), ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).render_number_display_shadow, model, vertexConsumerProvider, class_327.class_6415.field_33993, ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).render_number_display_background_color ? ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).number_display_background_color.getRGB() : 0, light);
        matrixStack.method_22909();
    }

    @Unique
    private static void drawHeart(Matrix4f model, class_4588 vertexConsumer, float x, HeartTypeEnum type, class_1309 livingEntity) {
        Object additionalIconEffects = "";
        if (type != HeartTypeEnum.YELLOW_FULL && type != HeartTypeEnum.YELLOW_HALF && type != HeartTypeEnum.EMPTY && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).show_heart_effects) {
            additionalIconEffects = HeartTypeEnum.addStatusIcon(livingEntity) + HeartTypeEnum.addHardcoreIcon(livingEntity);
        }
        class_2960 heartIcon = class_2960.method_60655((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        class_2960 vanillaHeartIcon = class_2960.method_60655((String)"vitalstats", (String)("textures/gui/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)(((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).use_vanilla_textures ? vanillaHeartIcon : heartIcon));
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        vertexConsumer.method_22918(model, x, 0.0f - heartSize, 0.0f).method_22913(minU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, 0.0f - heartSize, 0.0f).method_22913(maxU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, 0.0f, 0.0f).method_22913(maxU, minV);
        vertexConsumer.method_22918(model, x, 0.0f, 0.0f).method_22913(minU, minV);
    }

    @Unique
    private static void drawTotem(Matrix4f model, class_4588 vertexConsumer, float x, TotemTypeEnum type) {
        RenderSystem.setShader(class_757::method_34542);
        class_2960 totemIcon = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).use_vanilla_textures ? type.vanillaIcon : type.icon;
        RenderSystem.setShaderTexture((int)0, (class_2960)totemIcon);
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float iconSize = 9.0f;
        vertexConsumer.method_22918(model, x, 0.0f - iconSize, 0.0f).method_22913(minU, maxV);
        vertexConsumer.method_22918(model, x - iconSize, 0.0f - iconSize, 0.0f).method_22913(maxU, maxV);
        vertexConsumer.method_22918(model, x - iconSize, 0.0f, 0.0f).method_22913(maxU, minV);
        vertexConsumer.method_22918(model, x, 0.0f, 0.0f).method_22913(minU, minV);
    }

    @Unique
    private void renderTotemCounter(class_1657 player, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        boolean playerHasHealthIndicator;
        int totemCount = TotemTracker.getTotemCount(player);
        if (totemCount <= 0) {
            return;
        }
        double d = this.field_4676.method_23168((class_1297)player);
        matrixStack.method_22903();
        float scale = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).size;
        boolean healthIndicatorsEnabled = Config.getHeartsRenderingEnabled() || Config.getOverrideAllFiltersEnabled();
        boolean bl = playerHasHealthIndicator = (RenderTracker.isInUUIDS((class_1309)player) || Config.getOverrideAllFiltersEnabled()) && healthIndicatorsEnabled;
        if (playerHasHealthIndicator) {
            int healthYellow;
            matrixStack.method_46416(0.0f, player.method_17682() + 0.5f, 0.0f);
            playerAsT = player;
            if ((this.method_3921((class_1297)playerAsT) || ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).force_higher_offset_for_players && player != this.client.field_1724) && d <= 4096.0) {
                matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                if (d < 100.0 && player.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                }
            }
            float absorptionHeightOffset = 0.0f;
            if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS && (healthYellow = class_3532.method_15386((float)player.method_6067())) > 0) {
                int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
                int heartsPerRow = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).icons_per_row;
                int absorptionRows = class_3532.method_15386((float)((float)heartsYellow / (float)heartsPerRow));
                double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsYellow / (double)heartsPerRow), -3.0) * 5.0;
                absorptionHeightOffset = (float)((double)absorptionRows * ((double)heartsYellow / heartDensity)) * scale * 15.0f;
            }
            matrixStack.method_22904(0.0, (double)(16.0f * scale + absorptionHeightOffset), 0.0);
        } else {
            matrixStack.method_46416(0.0f, player.method_17682() + 0.4f, 0.0f);
            playerAsT = player;
            if (this.method_3921((class_1297)playerAsT) && d <= 4096.0) {
                matrixStack.method_22904(0.0, (double)(12.0f * scale), 0.0);
                if (d < 100.0 && player.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                }
            } else {
                matrixStack.method_22904(0.0, (double)(8.0f * scale), 0.0);
            }
        }
        matrixStack.method_22907(this.field_4676.method_24197());
        matrixStack.method_22905(-scale, scale, scale);
        matrixStack.method_22904(0.0, ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).display_offset, 0.0);
        class_289 tessellator = class_289.method_1348();
        class_287 vertexConsumer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f model = matrixStack.method_23760().method_23761();
        float iconX = 10.0f;
        EntityRendererMixin.drawTotem(model, (class_4588)vertexConsumer, iconX, TotemTypeEnum.TOTEM);
        try {
            class_9801 builtBuffer = vertexConsumer.method_60794();
            if (builtBuffer != null) {
                class_286.method_43433((class_9801)builtBuffer);
                builtBuffer.close();
            }
        }
        catch (Exception absorptionRows) {
            // empty catch block
        }
        matrixStack.method_22909();
        if (totemCount > 0) {
            matrixStack.method_22903();
            if (playerHasHealthIndicator) {
                int healthYellow;
                matrixStack.method_46416(0.0f, player.method_17682() + 0.5f, 0.0f);
                playerAsT = player;
                if ((this.method_3921((class_1297)playerAsT) || ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).force_higher_offset_for_players && player != this.client.field_1724) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    if (d < 100.0 && player.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                }
                float absorptionHeightOffsetText = 0.0f;
                if (((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).indicator_type == HealthDisplayTypeEnum.HEARTS && (healthYellow = class_3532.method_15386((float)player.method_6067())) > 0) {
                    int heartsYellow = class_3532.method_15386((float)((float)healthYellow / 2.0f));
                    int heartsPerRow = ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).icons_per_row;
                    int absorptionRows = class_3532.method_15386((float)((float)heartsYellow / (float)heartsPerRow));
                    double heartDensity = 50.0 - Math.max(4.0 - Math.ceil((double)heartsYellow / (double)heartsPerRow), -3.0) * 5.0;
                    absorptionHeightOffsetText = (float)((double)absorptionRows * ((double)heartsYellow / heartDensity)) * scale * 15.0f;
                }
                matrixStack.method_22904(0.0, (double)(13.0f * scale + absorptionHeightOffsetText), 0.0);
            } else {
                matrixStack.method_46416(0.0f, player.method_17682() + 0.4f, 0.0f);
                playerAsT = player;
                if (this.method_3921((class_1297)playerAsT) && d <= 4096.0) {
                    matrixStack.method_22904(0.0, (double)(9.0f * scale), 0.0);
                    if (d < 100.0 && player.method_5770().method_8428().method_1189(class_8646.field_45158) != null) {
                        matrixStack.method_22904(0.0, (double)(10.349999f * scale), 0.0);
                    }
                } else {
                    matrixStack.method_22904(0.0, (double)(5.0f * scale), 0.0);
                }
            }
            matrixStack.method_22907(this.field_4676.method_24197());
            matrixStack.method_22905(scale, -scale, scale);
            matrixStack.method_22904(0.0, -((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).display_offset, 0.0);
            class_327 textRenderer = class_310.method_1551().field_1772;
            String countText = "x" + totemCount;
            Matrix4f textModel = matrixStack.method_23760().method_23761();
            float textX = 0.0f;
            float textY = -2.0f;
            textRenderer.method_27521(countText, textX, textY, 0xFFFFFF, true, textModel, vertexConsumerProvider, class_327.class_6415.field_33993, 0, light);
            matrixStack.method_22909();
        }
    }

    @Unique
    @Deprecated
    private static void drawVertex(Matrix4f model, class_4588 vertices, float x, float y, float u, float v) {
        vertices.method_22918(model, x, y, 0.0f).method_22913(u, v);
    }

    @Unique
    private static void drawHeartWithOffset(Matrix4f model, class_4588 vertexConsumer, float x, float y, HeartTypeEnum type, class_1309 livingEntity) {
        Object additionalIconEffects = "";
        if (type != HeartTypeEnum.YELLOW_FULL && type != HeartTypeEnum.YELLOW_HALF && type != HeartTypeEnum.EMPTY && ((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).show_heart_effects) {
            additionalIconEffects = HeartTypeEnum.addStatusIcon(livingEntity) + HeartTypeEnum.addHardcoreIcon(livingEntity);
        }
        class_2960 heartIcon = class_2960.method_60655((String)"minecraft", (String)("textures/gui/sprites/hud/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        class_2960 vanillaHeartIcon = class_2960.method_60655((String)"vitalstats", (String)("textures/gui/heart/" + (String)additionalIconEffects + type.icon + ".png"));
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)(((VitalStatsConfig)VitalStatsConfig.HANDLER.instance()).use_vanilla_textures ? vanillaHeartIcon : heartIcon));
        RenderSystem.enableDepthTest();
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float heartSize = 9.0f;
        vertexConsumer.method_22918(model, x, y - heartSize, 0.0f).method_22913(minU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, y - heartSize, 0.0f).method_22913(maxU, maxV);
        vertexConsumer.method_22918(model, x - heartSize, y, 0.0f).method_22913(maxU, minV);
        vertexConsumer.method_22918(model, x, y, 0.0f).method_22913(minU, minV);
    }
}

