/*
 * Decompiled with CFR 0.152.
 */
package org.devmc.gamemoderators;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.devmc.gamemoderators.VariableHandling;
import org.devmc.gamemoderators.command.BackupCommand;
import org.devmc.gamemoderators.command.ModeratorCommand;
import org.devmc.gamemoderators.command.PermissionsCommand;
import org.devmc.gamemoderators.command.SpectateCommand;
import org.devmc.gamemoderators.command.WarnCommand;
import org.devmc.gamemoderators.event.onEntityTick;

public class GameModerators
implements ModInitializer {
    public static final String MODERATORS_FILE = "GameModerators\\moderation\\moderators.dat";
    public static final String advancedSettingsFile = "GameModerators\\advanced_settings.json";
    public static final File warningsDirectory = new File("GameModerators\\moderation\\players\\");
    public static final String automodFile = "GameModerators\\moderation\\automod_settings.json";
    public static final File autoModBannedFile = new File("GameModerators\\moderation\\auto_banned_players.json");
    public static final String backupDirectory = "GameModerators\\backups\\";
    public static class_3335 automodBannedPlayerList = new class_3335(autoModBannedFile);
    public static class_3335 bannedPlayerList = new class_3335(new File("banned-players.json"));
    public static boolean anticheatEnabled;
    public static String moderatorGamemode;
    public static MinecraftServer server;
    public static final Gson gson;
    public static int maxWarnings;

    public void onInitialize() {
        GameModerators.modSetup();
        GameModerators.eventSetup();
        GameModerators.registerCommands();
        System.out.println(Arrays.toString(VariableHandling.moderators()) + " are game moderators");
        System.out.println("Anti-cheat enabled = " + anticheatEnabled);
        onEntityTick.initialize();
    }

    private static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, commandBuildContext, dedicated) -> {
            ModeratorCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SpectateCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PermissionsCommand.register((CommandDispatcher<class_2168>)dispatcher);
            WarnCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BackupCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        RegistryEntryAddedCallback.event((class_2378)class_7923.field_41192).register((rawId, id, object) -> System.out.println("Registered command: " + String.valueOf(id)));
    }

    private static void modSetup() {
        File moderatorsFile = new File(MODERATORS_FILE);
        File autoModFile = new File(automodFile);
        File backupDir = new File(backupDirectory);
        try {
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            if (!warningsDirectory.exists()) {
                warningsDirectory.mkdirs();
            }
            if (!moderatorsFile.exists()) {
                moderatorsFile.createNewFile();
            }
            if (!autoModBannedFile.exists()) {
                autoModBannedFile.createNewFile();
            }
            JsonObject automodSettings = new JsonObject();
            if (!autoModFile.exists()) {
                autoModFile.createNewFile();
                try {
                    automodSettings.addProperty("max_warnings", "-1");
                    FileWriter writer = new FileWriter(automodFile);
                    gson.toJson((JsonElement)automodSettings, (Appendable)writer);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            maxWarnings = automodSettings.get("max_warnings").getAsInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void eventSetup() {
        ServerTickEvents.START_SERVER_TICK.register(server -> server.method_3760().method_14571().forEach(player -> {
            File playerFile = new File(warningsDirectory, player.method_5477().getString() + ".json");
            if (!playerFile.exists()) {
                try {
                    JsonObject playerData = new JsonObject();
                    playerData.addProperty("warnings", (Number)0);
                    playerData.addProperty("status", "online");
                    FileWriter writer = new FileWriter(playerFile);
                    gson.toJson((JsonElement)playerData, (Appendable)writer);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            int warnings = GameModerators.getPlayerWarnings(player.method_5477().getString());
            try {
                JsonObject playerData = GameModerators.getPlayerData(playerFile);
                if (warnings > maxWarnings && maxWarnings > 0) {
                    class_3336 bannedPlayerEntry = new class_3336(player.method_7334());
                    bannedPlayerList.method_14633((class_3330)bannedPlayerEntry);
                    automodBannedPlayerList.method_14633((class_3330)bannedPlayerEntry);
                    try {
                        playerData.addProperty("status", "banned");
                        GameModerators.writePlayerData(playerFile, playerData);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (playerData.get("status").getAsString().equals("banned") || automodBannedPlayerList.method_14650(player.method_7334()) || bannedPlayerList.method_14650(player.method_7334())) {
                    player.field_13987.method_14367(class_2561.method_30163((String)"You are banned from the server."));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        ServerPlayConnectionEvents.DISCONNECT.register((player, server) -> {
            String playerName = player.method_32311().method_5477().getString();
            File playerFile = new File(warningsDirectory, playerName + ".json");
            try {
                JsonObject playerData = GameModerators.getPlayerData(playerFile);
                playerData.addProperty("status", "offline");
                GameModerators.writePlayerData(playerFile, playerData);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static int getPlayerWarnings(String target) {
        File playerFile = new File(warningsDirectory, target + ".json");
        try {
            JsonObject playerData = GameModerators.getPlayerData(playerFile);
            return playerData.get("warnings").getAsInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void backupDirectory(String sourceDirectory, String destinationDirectory) throws IOException {
        Path source = Paths.get(sourceDirectory, new String[0]);
        Path destination = Paths.get(destinationDirectory, new String[0]);
        if (sourceDirectory.isEmpty()) {
            source = Paths.get("", new String[0]).toAbsolutePath();
        }
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            Path finalSource = source;
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(sourceFile -> {
                try {
                    Path relativePath = finalSource.relativize((Path)sourceFile);
                    Path destinationFile = destination.resolve(relativePath);
                    Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                    Files.copy(sourceFile, destinationFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static void backupFile(String sourceFile, String destinationDirectory) {
        File source = new File(sourceFile);
        Path destination = Paths.get(destinationDirectory, source.getName());
        try {
            Files.copy(source.toPath(), destination, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void broadcastToOps(String message, boolean overlay) {
        for (class_3222 onlinePlayer : server.method_3760().method_14571()) {
            if (!server.method_3760().method_14569(onlinePlayer.method_7334())) continue;
            if (overlay) {
                onlinePlayer.method_7353(class_2561.method_30163((String)message), true);
                continue;
            }
            onlinePlayer.method_43496(class_2561.method_30163((String)message));
        }
    }

    public static void broadcastToMods(String message, boolean overlay) throws IOException {
        for (class_3222 onlinePlayer : server.method_3760().method_14571()) {
            if (!VariableHandling.isPlayerModerator(onlinePlayer.method_5477().getString(), MODERATORS_FILE)) continue;
            if (overlay) {
                onlinePlayer.method_7353(class_2561.method_30163((String)message), true);
                continue;
            }
            onlinePlayer.method_43496(class_2561.method_30163((String)message));
        }
    }

    public static JsonObject getPlayerData(File playerFile) throws IOException {
        JsonObject playerData = new JsonObject();
        if (playerFile.exists()) {
            JsonParser parser = new JsonParser();
            try (FileReader reader = new FileReader(playerFile);){
                playerData = parser.parse((Reader)reader).getAsJsonObject();
            }
        } else {
            playerFile.createNewFile();
            playerData.addProperty("warnings", (Number)0);
            playerData.addProperty("status", "online");
        }
        return playerData;
    }

    public static void writePlayerData(File playerFile, JsonObject playerData) throws IOException {
        try (FileWriter writer = new FileWriter(playerFile);){
            gson.toJson((JsonElement)playerData, (Appendable)writer);
        }
    }

    static {
        moderatorGamemode = "SPECTATOR";
        gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            anticheatEnabled = VariableHandling.getAnticheatEnabled();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

