/*
 * Decompiled with CFR 0.152.
 */
package org.devmc.gamemoderators.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.devmc.gamemoderators.GameModerators;

public class BackupCommand {
    private static final String[] backupOptions = new String[]{"ADVANCEMENTS", "PLAYER-DATA", "MINECRAFT-WORLD", "WORLD-LEVEL", "SERVER-PROPERTIES", "MODS"};
    private static String backupType;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backup").requires(source -> source.method_9259(3))).then(class_2170.method_9247((String)"create").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9247((String)"all").executes(context -> BackupCommand.createBackup((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), "ALL")))).then(class_2170.method_9247((String)"specific").then(class_2170.method_9244((String)"content", (ArgumentType)StringArgumentType.word()).suggests(BackupCommand.getBackupSuggestions()).executes(context -> BackupCommand.createBackup((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"content")))))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            File directory = new File("GameModerators\\backups\\");
            File[] backups = directory.listFiles();
            if (backups != null) {
                for (File file : backups) {
                    if (!file.isDirectory()) continue;
                    builder.suggest(file.getName());
                }
            }
            return builder.buildFuture();
        }).executes(context -> BackupCommand.deleteBackup((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(class_2170.method_9247((String)"help").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9226(() -> class_2561.method_30163((String)"Backup types \n 'ALL' - Every file in your minecraft server folder \n 'ADVANCEMENTS' - All the players' advancements \n 'PLAYER-DATA' - All the saved players and their inventories \n 'MINECRAFT-WORLD' - The minecraft world data, including entities, players etc. \n 'WORLD-LEVEL' - Only the minecraft world (buildings) \n 'SERVER-PROPERTIES' - Things such as the IP address of the server, banned players, whitelist etc. \n 'MODS' - The server's mods \n \n All the backups can be found in GameModerators\\backups\\"), false);
            return 0;
        })));
    }

    private static SuggestionProvider<class_2168> getBackupSuggestions() {
        return (context, builder) -> {
            for (String backup : backupOptions) {
                builder.suggest(backup);
            }
            return CompletableFuture.completedFuture(builder.build());
        };
    }

    private static int createBackup(CommandContext<class_2168> context, String name, String content) {
        class_2168 source = (class_2168)context.getSource();
        File directory = new File("GameModerators\\backups\\" + name);
        if (directory.exists()) {
            source.method_9213(class_2561.method_30163((String)"A backup with that name already exists"));
            return 0;
        }
        directory.mkdirs();
        source.method_9226(() -> class_2561.method_30163((String)("Creating backup for " + content.toLowerCase() + " on directory " + String.valueOf(directory))), true);
        try {
            switch (content) {
                case "ALL": {
                    GameModerators.backupDirectory("", "GameModerators\\backups\\" + name);
                    break;
                }
                case "ADVANCEMENTS": {
                    backupType = "world\\advancements\\";
                    GameModerators.backupDirectory(backupType, "GameModerators\\backups\\" + name + backupType);
                    break;
                }
                case "PLAYER-DATA": {
                    backupType = "world\\playerdata\\";
                    GameModerators.backupDirectory(backupType, "GameModerators\\backups\\" + name + backupType);
                    break;
                }
                case "MINECRAFT-WORLD": {
                    backupType = "world\\";
                    GameModerators.backupDirectory(backupType, "GameModerators\\backups\\" + name + backupType);
                    break;
                }
                case "WORLD-LEVEL": {
                    backupType = "world\\level.dat";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    break;
                }
                case "SERVER-PROPERTIES": {
                    backupType = "server.properties";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    backupType = "banned-ips.json";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    backupType = "banned-players.json";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    backupType = "ops.json";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    backupType = "usercache.json";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    backupType = "whitelist.json";
                    GameModerators.backupFile(backupType, "GameModerators\\backups\\" + name);
                    break;
                }
                case "MODS": {
                    backupType = "mods\\";
                    GameModerators.backupDirectory(backupType, "GameModerators\\backups\\" + name + backupType);
                    break;
                }
                default: {
                    source.method_9213(class_2561.method_30163((String)"Unknown subcommand"));
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    private static int deleteBackup(CommandContext<class_2168> context, String name) {
        class_2168 source = (class_2168)context.getSource();
        File directory = new File("GameModerators\\backups\\" + name);
        if (!directory.exists()) {
            source.method_9213(class_2561.method_30163((String)("Backup with the name " + name + " does not exist")));
            return 0;
        }
        try {
            Files.walk(directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            source.method_9226(() -> class_2561.method_30163((String)("Backup " + name + " deleted successfully")), true);
            return 1;
        }
        catch (IOException e) {
            source.method_9213(class_2561.method_30163((String)("Failed to delete backup " + name)));
            e.printStackTrace();
            return 0;
        }
    }
}

