/*
 * Decompiled with CFR 0.152.
 */
package org.devmc.gamemoderators.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.devmc.gamemoderators.GameModerators;
import org.devmc.gamemoderators.VariableHandling;

public class ModeratorCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"moderator").requires(source -> source.method_9259(3))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"setTarget", (ArgumentType)class_2186.method_9305()).executes(context -> ModeratorCommand.execute((CommandContext<class_2168>)context, 1))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"removeTarget", (ArgumentType)class_2186.method_9305()).executes(context -> ModeratorCommand.execute((CommandContext<class_2168>)context, 2))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"gamemode").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"default").then((ArgumentBuilder)class_2170.method_9247((String)"spectator"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "SPECTATOR", 1))).then((ArgumentBuilder)class_2170.method_9247((String)"creative"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "CREATIVE", 1))).then((ArgumentBuilder)class_2170.method_9247((String)"survival"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "SURVIVAL", 1))).then((ArgumentBuilder)class_2170.method_9247((String)"adventure"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "ADVENTURE", 1)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then((ArgumentBuilder)class_2170.method_9247((String)"spectator"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "SPECTATOR", 2))).then((ArgumentBuilder)class_2170.method_9247((String)"creative"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "CREATIVE", 2))).then((ArgumentBuilder)class_2170.method_9247((String)"survival"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "SURVIVAL", 2))).then((ArgumentBuilder)class_2170.method_9247((String)"adventure"))).executes(context -> ModeratorCommand.changeGamemode((CommandContext<class_2168>)context, "ADVENTURE", 2)))));
    }

    private static int execute(CommandContext<class_2168> context, int action) throws CommandSyntaxException {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
        class_3222 player = action == 1 ? class_2186.method_9315(context, (String)"setTarget") : class_2186.method_9315(context, (String)"removeTarget");
        String playerName = player.method_5477().getString();
        assert (sourcePlayer != null);
        try {
            if (action == 1) {
                if (!VariableHandling.isPlayerModerator(playerName, "GameModerators\\moderation\\moderators.dat")) {
                    FileWriter fw = new FileWriter("GameModerators\\moderation\\moderators.dat", true);
                    PrintWriter pw = new PrintWriter(fw);
                    pw.println(playerName);
                    pw.close();
                    sourcePlayer.method_43496(class_2561.method_30163((String)("Successfully made " + playerName + " a moderator")));
                    GameModerators.broadcastToOps(playerName + " is now a moderator", false);
                    GameModerators.broadcastToMods("Welcome " + playerName + " to the moderator team!", false);
                } else {
                    sourcePlayer.method_7353(class_2561.method_30163((String)(playerName + " is already a moderator")), true);
                }
            } else {
                Path moderatorsFilePath = Paths.get("GameModerators\\moderation\\moderators.dat", new String[0]);
                List<String> lines = Files.readAllLines(moderatorsFilePath);
                List updatedLines = lines.stream().filter(line -> !line.equals(playerName)).collect(Collectors.toList());
                Files.write(moderatorsFilePath, updatedLines, new OpenOption[0]);
                sourcePlayer.method_43496(class_2561.method_30163((String)("Successfully removed " + playerName + " from moderators list")));
                GameModerators.broadcastToOps(playerName + " was removed from the moderator team.", false);
                GameModerators.broadcastToMods(playerName + " was removed from the moderator team. Goodbye.", false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int changeGamemode(CommandContext<class_2168> context, String gamemode, int action) {
        class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
        if (action == 1) {
            try {
                if (sourcePlayer != null) {
                    sourcePlayer.method_43496(class_2561.method_30163((String)("Set " + gamemode + " mode as the default gamemode for moderators")));
                    GameModerators.broadcastToMods(sourcePlayer.method_5477().getString() + "set the default gamemode for moderators to " + gamemode, false);
                }
                GameModerators.moderatorGamemode = gamemode;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (action == 2) {
            try {
                if (sourcePlayer != null) {
                    sourcePlayer.method_43496(class_2561.method_30163((String)("Set " + gamemode + " as the gamemode for all online moderators")));
                    GameModerators.broadcastToMods(sourcePlayer.method_5477().getString() + "set the gamemode for all online moderators to " + gamemode, false);
                }
                GameModerators.server.method_3760().method_14571().forEach(player -> {
                    try {
                        if (VariableHandling.isPlayerModerator(player.method_5477().getString(), "GameModerators\\moderation\\moderators.dat")) {
                            player.method_7336(class_1934.valueOf((String)gamemode));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return action;
    }
}

