/*
 * Decompiled with CFR 0.152.
 */
package org.devmc.gamemoderators.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.devmc.gamemoderators.GameModerators;
import org.devmc.gamemoderators.VariableHandling;

public class WarnCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warn").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("remove");
            builder.suggest("get");
            builder.suggest("add");
            return builder.buildFuture();
        }).executes(context -> {
            String action = StringArgumentType.getString((CommandContext)context, (String)"action");
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
            class_3222 source = ((class_2168)context.getSource()).method_44023();
            try {
                if (source != null && (VariableHandling.isPlayerModerator(source.method_5477().getString(), "GameModerators\\moderation\\moderators.dat") || source.method_5687(3))) {
                    switch (action) {
                        case "remove": {
                            return WarnCommand.removeWarning((CommandContext<class_2168>)context, target, null);
                        }
                        case "get": {
                            return WarnCommand.getWarnings((CommandContext<class_2168>)context, target, 0);
                        }
                        case "add": {
                            throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Missing reason for warning.")).create();
                        }
                    }
                    throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Invalid subcommand. Use 'remove', 'get', or 'add'.")).create();
                }
                return 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            String action = StringArgumentType.getString((CommandContext)context, (String)"action");
            if ("remove".equals(action)) {
                class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
                int warnNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"number");
                return WarnCommand.removeWarning((CommandContext<class_2168>)context, target, warnNumber);
            }
            if ("get".equals(action)) {
                class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
                int warnNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"number");
                return WarnCommand.getWarnings((CommandContext<class_2168>)context, target, warnNumber);
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Specify 'remove' or 'get' to perform an action.")).create();
        }))))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
            String reason = StringArgumentType.getString((CommandContext)context, (String)"reason");
            return WarnCommand.warnPlayer((CommandContext<class_2168>)context, target, reason);
        })))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int removeWarning(CommandContext<class_2168> context, class_3222 target, Integer warningNumber) {
        class_2168 source = (class_2168)context.getSource();
        File playerFile = new File(GameModerators.warningsDirectory, target.method_5477().getString() + ".json");
        if (target == source.method_44023() && !source.method_9259(3)) {
            source.method_9213(class_2561.method_30163((String)"You can't remove your warnings!"));
            return 0;
        }
        try {
            JsonObject playerData = GameModerators.getPlayerData(playerFile);
            if (warningNumber != null) {
                String warningKey = "warning" + warningNumber;
                if (!playerData.has(warningKey)) {
                    source.method_9226(() -> class_2561.method_30163((String)("Warning " + warningNumber + " for player " + target.method_5477().getString() + " does not exist.")), false);
                    return 0;
                }
                playerData.remove(warningKey);
                int warningCount = playerData.get("warnings").getAsInt();
                for (int i = warningNumber + 1; i <= warningCount; ++i) {
                    String currentKey = "warning" + i;
                    if (!playerData.has(currentKey)) continue;
                    String currentValue = playerData.get(currentKey).getAsString();
                    playerData.remove(currentKey);
                    playerData.addProperty("warning" + (i - 1), currentValue);
                }
                playerData.addProperty("warnings", (Number)(warningCount - 1));
                source.method_9226(() -> class_2561.method_30163((String)("Removed warning " + warningNumber + " from player " + target.method_5477().getString())), true);
            } else {
                int warningCount = playerData.get("warnings").getAsInt();
                for (int i = 1; i <= warningCount; ++i) {
                    String currentKey = "warning" + i;
                    if (!playerData.has(currentKey)) continue;
                    playerData.remove(currentKey);
                }
                playerData.addProperty("warnings", (Number)0);
                source.method_9226(() -> class_2561.method_30163((String)("All warnings for player " + target.method_5477().getString() + " have been removed.")), true);
            }
            GameModerators.writePlayerData(playerFile, playerData);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static int getWarnings(CommandContext<class_2168> context, class_3222 target, int warnNumber) {
        class_2168 source = (class_2168)context.getSource();
        File playerFile = new File(GameModerators.warningsDirectory, target.method_5477().getString() + ".json");
        try {
            JsonObject playerData = GameModerators.getPlayerData(playerFile);
            if (warnNumber > 0) {
                String warningKey = "warning" + warnNumber;
                if (playerData.has(warningKey)) {
                    String reason = playerData.get(warningKey).getAsString();
                    source.method_9226(() -> class_2561.method_30163((String)("Warning " + warnNumber + " for player " + target.method_5477().getString() + ": " + reason)), false);
                    return 1;
                }
                source.method_9226(() -> class_2561.method_30163((String)("Player " + target.method_5477().getString() + " does not have warning " + warnNumber)), false);
                return 0;
            }
            int warnings = playerData.get("warnings").getAsInt();
            source.method_9226(() -> class_2561.method_30163((String)("Player " + target.method_5477().getString() + " has " + warnings + " warnings.")), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static int warnPlayer(CommandContext<class_2168> context, class_3222 target, String reason) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() == target && source.method_9259(3)) {
            source.method_9213(class_2561.method_30163((String)"You can't warn yourself!"));
            return 0;
        }
        if (target.method_5687(3)) {
            source.method_9213(class_2561.method_30163((String)"You can't warn an operator!"));
            return 0;
        }
        File playerFile = new File(GameModerators.warningsDirectory, target.method_5477().getString() + ".json");
        try {
            JsonObject playerData = GameModerators.getPlayerData(playerFile);
            int warnings = playerData.get("warnings").getAsInt() + 1;
            playerData.addProperty("warnings", (Number)warnings);
            String warningKey = "warning" + warnings;
            playerData.addProperty(warningKey, reason);
            playerData.addProperty("status", "online");
            GameModerators.writePlayerData(playerFile, playerData);
            source.method_9226(() -> class_2561.method_30163((String)("Player " + target.method_5477().getString() + " warned: " + reason)), true);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

