/*
 * Decompiled with CFR 0.152.
 */
package com.example.gradientchat;

import com.example.gradientchat.GradientChatMod;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class GradientManager {
    private static final int NUM_PRESETS = 5;
    private static final int COLORS_PER_PRESET = 10;
    private final List<GradientPreset> hexPresets = new ArrayList<GradientPreset>();
    private final List<GradientPreset> colorCodePresets = new ArrayList<GradientPreset>();
    private int currentHexPresetIndex = 0;
    private int currentColorCodePresetIndex = 0;
    private boolean useColorCodes = false;
    private boolean enabled = true;

    public GradientManager() {
        this.initializeDefaultPresets();
        this.loadPresets();
    }

    private void initializeDefaultPresets() {
        this.hexPresets.add(new GradientPreset("\ud83d\udd25 Red Gradient (dark to light)", new int[]{0x8B0000, 0xA60000, 0xC80000, 0xE00000, 0xFF0000, 0xFF4040, 0xFF7373, 0xFF9999, 0xFF0000, 0x8B0000}));
        this.hexPresets.add(new GradientPreset("\ud83d\udd35 Blue Gradient (deep to sky)", new int[]{139, 205, 2003199, 49151, 8900346, 11591910, 0xE0FFFF, 0xF0FFFF, 49151, 139}));
        this.hexPresets.add(new GradientPreset("\ud83d\udc9a Green Gradient (forest to lime)", new int[]{25600, 0x228B22, 3050327, 3978097, 6737322, 8388564, 10025880, 11403055, 3978097, 25600}));
        this.hexPresets.add(new GradientPreset("\ud83d\udfe3 Purple Gradient (rich to light)", new int[]{4915330, 6950317, 0x800080, 10494192, 14315734, 14204888, 15132410, 0xF8F8FF, 10494192, 4915330}));
        this.hexPresets.add(new GradientPreset("\ud83c\udf08 Rainbow (hard steps, not blended)", new int[]{0xFF0000, 0xFF7F00, 0xFFFF00, 65280, 255, 4915330, 9109759, 0xFF0000, 0xFF7F00, 0xFFFF00}));
        this.colorCodePresets.add(new GradientPreset("\ud83d\udd25 Red Gradient (dark to light)", new int[]{0x8B0000, 0xA60000, 0xC80000, 0xE00000, 0xFF0000, 0xFF4040, 0xFF7373, 0xFF9999, 0xFF0000, 0x8B0000}, "&4H &cE &6L &eL &fO"));
        this.colorCodePresets.add(new GradientPreset("\ud83d\udd35 Blue Gradient (deep to sky)", new int[]{139, 205, 2003199, 49151, 8900346, 11591910, 0xE0FFFF, 0xF0FFFF, 49151, 139}, "&1H &9E &bL &fL &fO"));
        this.colorCodePresets.add(new GradientPreset("\ud83d\udc9a Green Gradient (forest to lime)", new int[]{25600, 0x228B22, 3050327, 3978097, 6737322, 8388564, 10025880, 11403055, 3978097, 25600}, "&2H &aE &eL &fL &fO"));
        this.colorCodePresets.add(new GradientPreset("\ud83d\udfe3 Purple Gradient (rich to light)", new int[]{4915330, 6950317, 0x800080, 10494192, 14315734, 14204888, 15132410, 0xF8F8FF, 10494192, 4915330}, "&5H &dE &fL &dL &5O"));
        this.colorCodePresets.add(new GradientPreset("\ud83c\udf08 Rainbow (hard steps, not blended)", new int[]{0xFF0000, 0xFF7F00, 0xFFFF00, 65280, 255, 4915330, 9109759, 0xFF0000, 0xFF7F00, 0xFFFF00}, "&cH &6E &eL &aL &bO &9! &5? &4."));
    }

    public void savePresets() {
        try {
            File configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), "gradient-chat");
            if (!configDir.exists() && !configDir.mkdirs()) {
                GradientChatMod.LOGGER.error("Failed to create config directory");
                return;
            }
            File presetsFile = new File(configDir, "presets.dat");
            class_2487 root = new class_2487();
            root.method_10569("currentHexPreset", this.currentHexPresetIndex);
            root.method_10569("currentColorCodePreset", this.currentColorCodePresetIndex);
            root.method_10556("useColorCodes", this.useColorCodes);
            root.method_10556("enabled", this.enabled);
            class_2499 hexPresetsList = new class_2499();
            for (GradientPreset preset : this.hexPresets) {
                class_2487 presetNbt = new class_2487();
                presetNbt.method_10582("name", preset.getName());
                class_2499 colorsList = new class_2499();
                for (int color : preset.getColors()) {
                    class_2487 colorNbt = new class_2487();
                    colorNbt.method_10569("value", color);
                    colorsList.add((Object)colorNbt);
                }
                presetNbt.method_10566("colors", (class_2520)colorsList);
                hexPresetsList.add((Object)presetNbt);
            }
            class_2499 colorCodePresetsList = new class_2499();
            for (GradientPreset preset : this.colorCodePresets) {
                class_2487 presetNbt = new class_2487();
                presetNbt.method_10582("name", preset.getName());
                class_2499 colorsList = new class_2499();
                for (int color : preset.getColors()) {
                    class_2487 colorNbt = new class_2487();
                    colorNbt.method_10569("value", color);
                    colorsList.add((Object)colorNbt);
                }
                presetNbt.method_10566("colors", (class_2520)colorsList);
                if (preset.getColorCodes() != null) {
                    presetNbt.method_10582("colorCodes", preset.getColorCodes());
                }
                colorCodePresetsList.add((Object)presetNbt);
            }
            root.method_10566("hexPresets", (class_2520)hexPresetsList);
            root.method_10566("colorCodePresets", (class_2520)colorCodePresetsList);
            class_2507.method_10630((class_2487)root, (Path)presetsFile.toPath());
        }
        catch (IOException e) {
            GradientChatMod.LOGGER.error("Failed to save presets", (Throwable)e);
        }
    }

    public void loadPresets() {
        File configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), "gradient-chat");
        File presetsFile = new File(configDir, "presets.dat");
        if (!presetsFile.exists()) {
            return;
        }
        try {
            class_2499 colorCodePresetsList;
            class_2499 hexPresetsList;
            class_2487 root = class_2507.method_10633((Path)presetsFile.toPath());
            if (root == null) {
                return;
            }
            this.currentHexPresetIndex = root.method_10550("currentHexPreset").orElse(0);
            this.currentColorCodePresetIndex = root.method_10550("currentColorCodePreset").orElse(0);
            if (root.method_10545("useColorCodes")) {
                this.useColorCodes = root.method_10577("useColorCodes").orElse(false);
            }
            if ((hexPresetsList = root.method_10554("hexPresets").orElse(new class_2499())).size() == 5) {
                this.hexPresets.clear();
                for (int i = 0; i < hexPresetsList.size(); ++i) {
                    class_2487 presetNbt = hexPresetsList.method_10602(i).orElse(new class_2487());
                    String name = presetNbt.method_10558("name").orElse("");
                    class_2499 colorsList = presetNbt.method_10554("colors").orElse(new class_2499());
                    int[] colors = new int[10];
                    for (int j = 0; j < 10; ++j) {
                        colors[j] = colorsList.method_10602(j).orElse(new class_2487()).method_10550("value").orElse(0);
                    }
                    this.hexPresets.add(new GradientPreset(name, colors));
                }
            }
            if ((colorCodePresetsList = root.method_10554("colorCodePresets").orElse(new class_2499())).size() == 5) {
                this.colorCodePresets.clear();
                for (int i = 0; i < colorCodePresetsList.size(); ++i) {
                    class_2487 presetNbt = colorCodePresetsList.method_10602(i).orElse(new class_2487());
                    String name = presetNbt.method_10558("name").orElse("");
                    class_2499 colorsList = presetNbt.method_10554("colors").orElse(new class_2499());
                    int[] colors = new int[10];
                    for (int j = 0; j < 10; ++j) {
                        colors[j] = colorsList.method_10602(j).orElse(new class_2487()).method_10550("value").orElse(0);
                    }
                    String colorCodes = "";
                    if (presetNbt.method_10545("colorCodes")) {
                        colorCodes = presetNbt.method_10558("colorCodes").orElse("");
                    }
                    this.colorCodePresets.add(new GradientPreset(name, colors, colorCodes));
                }
            }
        }
        catch (IOException e) {
            GradientChatMod.LOGGER.error("Failed to load presets", (Throwable)e);
        }
    }

    public GradientPreset getCurrentPreset() {
        return this.useColorCodes ? this.colorCodePresets.get(this.currentColorCodePresetIndex) : this.hexPresets.get(this.currentHexPresetIndex);
    }

    public void setCurrentPresetIndex(int index) {
        if (this.useColorCodes) {
            if (index >= 0 && index < this.colorCodePresets.size()) {
                this.currentColorCodePresetIndex = index;
                this.savePresets();
            }
        } else if (index >= 0 && index < this.hexPresets.size()) {
            this.currentHexPresetIndex = index;
            this.savePresets();
        }
    }

    public List<GradientPreset> getPresets() {
        return this.useColorCodes ? this.colorCodePresets : this.hexPresets;
    }

    public boolean isUsingColorCodes() {
        return this.useColorCodes;
    }

    public void setUseColorCodes(boolean useColorCodes) {
        this.useColorCodes = useColorCodes;
        this.savePresets();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.savePresets();
    }

    public String applyGradient(String message) {
        if (message.isEmpty() || !this.enabled) {
            return message;
        }
        if (message.matches("^[0-9]+$")) {
            return message;
        }
        GradientPreset preset = this.getCurrentPreset();
        if (this.useColorCodes) {
            return this.applyColorCodes(message, preset);
        }
        return this.applyHexGradient(message, preset);
    }

    private String applyColorCodes(String message, GradientPreset preset) {
        int numCodes;
        String colorCodePattern = preset.getColorCodes();
        if (colorCodePattern == null || colorCodePattern.isEmpty()) {
            return this.applyHexGradient(message, preset);
        }
        String[] codes = this.extractColorCodes(colorCodePattern);
        if (codes.length == 0) {
            return this.applyHexGradient(message, preset);
        }
        StringBuilder result = new StringBuilder();
        int messageLength = message.length();
        int charsPerCode = (int)Math.ceil((double)messageLength / (double)(numCodes = codes.length));
        if (charsPerCode < 1) {
            charsPerCode = 1;
        }
        for (int i = 0; i < messageLength; ++i) {
            int codeIndex = Math.min(i / charsPerCode, numCodes - 1);
            if (i % charsPerCode == 0 || i == 0) {
                result.append(codes[codeIndex]);
            }
            result.append(message.charAt(i));
        }
        return result.toString();
    }

    private String[] extractColorCodes(String pattern) {
        String[] parts = pattern.split(" ");
        String[] codes = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            codes[i] = part.length() >= 2 && part.charAt(0) == '&' ? part.substring(0, 2) : "&f";
        }
        return codes;
    }

    private String applyHexGradient(String message, GradientPreset preset) {
        int[] colors = preset.getColors();
        StringBuilder result = new StringBuilder();
        int messageLength = message.length();
        double charsPerSegment = (double)messageLength / (double)(colors.length - 1);
        for (int i = 0; i < messageLength; ++i) {
            char c = message.charAt(i);
            double segmentIndex = (double)i / charsPerSegment;
            int startColorIndex = (int)Math.floor(segmentIndex);
            int endColorIndex = Math.min(startColorIndex + 1, colors.length - 1);
            double factor = segmentIndex - (double)startColorIndex;
            int color = this.interpolateColor(colors[startColorIndex], colors[endColorIndex], factor);
            result.append(this.formatHexColor(color));
            result.append(c);
        }
        return result.toString();
    }

    private int interpolateColor(int color1, int color2, double factor) {
        Color c1 = new Color(color1);
        Color c2 = new Color(color2);
        int red = (int)((double)c1.getRed() * (1.0 - factor) + (double)c2.getRed() * factor);
        int green = (int)((double)c1.getGreen() * (1.0 - factor) + (double)c2.getGreen() * factor);
        int blue = (int)((double)c1.getBlue() * (1.0 - factor) + (double)c2.getBlue() * factor);
        return new Color(red, green, blue).getRGB() & 0xFFFFFF;
    }

    private String formatHexColor(int color) {
        return String.format("&#%06X", color);
    }

    public List<GradientPreset> getHexPresets() {
        return new ArrayList<GradientPreset>(this.hexPresets);
    }

    public List<GradientPreset> getColorCodePresets() {
        return new ArrayList<GradientPreset>(this.colorCodePresets);
    }

    public int getCurrentHexPresetIndex() {
        return this.currentHexPresetIndex;
    }

    public int getCurrentColorCodePresetIndex() {
        return this.currentColorCodePresetIndex;
    }

    public void setCurrentHexPresetIndex(int index) {
        if (index >= 0 && index < this.hexPresets.size()) {
            this.currentHexPresetIndex = index;
            this.savePresets();
        }
    }

    public void setCurrentColorCodePresetIndex(int index) {
        if (index >= 0 && index < this.colorCodePresets.size()) {
            this.currentColorCodePresetIndex = index;
            this.savePresets();
        }
    }

    public void updateColorCodePresetColor(int presetIndex, String color) {
        if (presetIndex >= 0 && presetIndex < this.colorCodePresets.size()) {
            try {
                int colorValue = Integer.parseInt(color.replace("#", ""), 16);
                this.colorCodePresets.get(presetIndex).setColor(0, colorValue);
                this.savePresets();
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid color format: " + color);
            }
        }
    }

    public void updateHexPresetColor(int presetIndex, String color) {
        if (presetIndex >= 0 && presetIndex < this.hexPresets.size()) {
            try {
                int colorValue = Integer.parseInt(color.replace("#", ""), 16);
                this.hexPresets.get(presetIndex).setColor(0, colorValue);
                this.savePresets();
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid color format: " + color);
            }
        }
    }

    public static class GradientPreset {
        private String name;
        private int[] colors;
        private String colorCodes;

        public GradientPreset(String name, int[] colors) {
            this.name = name;
            this.colors = colors;
            this.colorCodes = "";
        }

        public GradientPreset(String name, int[] colors, String colorCodes) {
            this.name = name;
            this.colors = colors;
            this.colorCodes = colorCodes;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int[] getColors() {
            return this.colors;
        }

        public String getColorCodes() {
            return this.colorCodes;
        }

        public void setColorCodes(String colorCodes) {
            this.colorCodes = colorCodes;
        }

        public void setColor(int index, int color) {
            if (index >= 0 && index < this.colors.length) {
                this.colors[index] = color;
            }
        }
    }
}

