/*
 * Decompiled with CFR 0.152.
 */
package com.example.gradientchat.gui;

import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ColorPickerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<Integer> colorCallback;
    private int selectedColor;
    private int hue = 0;
    private int saturation = 100;
    private int brightness = 100;
    private class_342 hexInput;

    public ColorPickerScreen(class_437 parent, int initialColor, Consumer<Integer> colorCallback) {
        super((class_2561)class_2561.method_43470((String)"Color Picker"));
        this.parent = parent;
        this.selectedColor = initialColor;
        this.colorCallback = colorCallback;
        float[] hsb = Color.RGBtoHSB(initialColor >> 16 & 0xFF, initialColor >> 8 & 0xFF, initialColor & 0xFF, null);
        this.hue = (int)(hsb[0] * 360.0f);
        this.saturation = (int)(hsb[1] * 100.0f);
        this.brightness = (int)(hsb[2] * 100.0f);
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.hexInput = new class_342(this.field_22793, centerX - 50, centerY + 70, 100, 20, (class_2561)class_2561.method_43470((String)"Hex"));
        this.hexInput.method_1880(9);
        this.hexInput.method_1852(String.format("&#%06X", this.selectedColor));
        this.hexInput.method_1863(this::onHexChanged);
        this.method_37063((class_364)this.hexInput);
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> {
            this.colorCallback.accept(this.selectedColor);
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(centerX - 50, centerY + 100, 100, 20).method_46431();
        this.method_37063((class_364)doneButton);
    }

    private void onHexChanged(String text) {
        if (text.startsWith("&#") && text.length() == 9) {
            try {
                int color;
                this.selectedColor = color = Integer.parseInt(text.substring(2), 16);
                float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
                this.hue = (int)(hsb[0] * 360.0f);
                this.saturation = (int)(hsb[1] * 100.0f);
                this.brightness = (int)(hsb[2] * 100.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -585162977);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int panelWidth = 200;
        int panelHeight = 220;
        context.method_25294(centerX - panelWidth / 2, centerY - panelHeight / 2, centerX + panelWidth / 2, centerY + panelHeight / 2, -13421773);
        context.method_49601(centerX - panelWidth / 2, centerY - panelHeight / 2, panelWidth, panelHeight, -1);
        context.method_25300(this.field_22793, "Color Picker", centerX, centerY - 100, 0xFFFFFF);
        int hueSliderWidth = 180;
        int hueSliderHeight = 15;
        int hueSliderX = centerX - hueSliderWidth / 2;
        int hueSliderY = centerY - 70;
        context.method_25294(hueSliderX, hueSliderY, hueSliderX + hueSliderWidth, hueSliderY + hueSliderHeight, -16777216);
        for (int i = 0; i < hueSliderWidth; ++i) {
            float hueValue = (float)i / (float)hueSliderWidth;
            int hueColor = Color.HSBtoRGB(hueValue, 1.0f, 1.0f);
            context.method_25294(hueSliderX + i, hueSliderY, hueSliderX + i + 1, hueSliderY + hueSliderHeight, 0xFF000000 | hueColor);
        }
        int hueX = hueSliderX + (int)((float)hueSliderWidth * ((float)this.hue / 360.0f));
        context.method_49601(hueX - 2, hueSliderY - 2, 5, hueSliderHeight + 4, -1);
        int gridSize = 100;
        int gridX = centerX - gridSize / 2;
        int gridY = centerY - 40;
        context.method_25294(gridX, gridY, gridX + gridSize, gridY + gridSize, -16777216);
        for (int s = 0; s < gridSize; ++s) {
            for (int b = 0; b < gridSize; ++b) {
                float satValue = (float)s / (float)gridSize;
                float briValue = (float)(gridSize - b) / (float)gridSize;
                int color = Color.HSBtoRGB((float)this.hue / 360.0f, satValue, briValue);
                context.method_25294(gridX + s, gridY + b, gridX + s + 1, gridY + b + 1, 0xFF000000 | color);
            }
        }
        int satX = gridX + (int)((float)this.saturation / 100.0f * (float)gridSize);
        int briY = gridY + (int)((float)(100 - this.brightness) / 100.0f * (float)gridSize);
        context.method_25294(satX - 5, briY, satX + 5, briY + 1, -1);
        context.method_25294(satX, briY - 5, satX + 1, briY + 5, -1);
        context.method_49601(satX - 3, briY - 3, 7, 7, -1);
        int previewSize = 30;
        int previewX = centerX - 60;
        int previewY = centerY + 65;
        context.method_25294(previewX, previewY, previewX + previewSize, previewY + previewSize, 0xFF000000 | this.selectedColor);
        context.method_49601(previewX, previewY, previewSize, previewSize, -1);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            int hueSliderWidth = 180;
            int hueSliderHeight = 15;
            int hueSliderX = centerX - hueSliderWidth / 2;
            int hueSliderY = centerY - 70;
            if (mouseY >= (double)hueSliderY && mouseY <= (double)(hueSliderY + hueSliderHeight) && mouseX >= (double)hueSliderX && mouseX <= (double)(hueSliderX + hueSliderWidth)) {
                this.hue = (int)((mouseX - (double)hueSliderX) / (double)hueSliderWidth * 360.0);
                this.updateSelectedColor();
                return true;
            }
            int gridSize = 100;
            int gridX = centerX - gridSize / 2;
            int gridY = centerY - 40;
            if (mouseX >= (double)gridX && mouseX <= (double)(gridX + gridSize) && mouseY >= (double)gridY && mouseY <= (double)(gridY + gridSize)) {
                this.saturation = (int)((mouseX - (double)gridX) / (double)gridSize * 100.0);
                this.brightness = (int)(((double)gridSize - (mouseY - (double)gridY)) / (double)gridSize * 100.0);
                this.updateSelectedColor();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            int hueSliderWidth = 180;
            int hueSliderHeight = 15;
            int hueSliderX = centerX - hueSliderWidth / 2;
            int hueSliderY = centerY - 70;
            if (mouseY >= (double)(hueSliderY - 5) && mouseY <= (double)(hueSliderY + hueSliderHeight + 5)) {
                int newHue = (int)((mouseX - (double)hueSliderX) / (double)hueSliderWidth * 360.0);
                this.hue = Math.max(0, Math.min(359, newHue));
                this.updateSelectedColor();
                return true;
            }
            int gridSize = 100;
            int gridX = centerX - gridSize / 2;
            int gridY = centerY - 40;
            int newSat = (int)((mouseX - (double)gridX) / (double)gridSize * 100.0);
            int newBri = (int)(((double)gridSize - (mouseY - (double)gridY)) / (double)gridSize * 100.0);
            this.saturation = Math.max(0, Math.min(100, newSat));
            this.brightness = Math.max(0, Math.min(100, newBri));
            this.updateSelectedColor();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updateSelectedColor() {
        this.selectedColor = Color.HSBtoRGB((float)this.hue / 360.0f, (float)this.saturation / 100.0f, (float)this.brightness / 100.0f) & 0xFFFFFF;
        this.hexInput.method_1852(String.format("&#%06X", this.selectedColor));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.colorCallback.accept(this.selectedColor);
            class_310.method_1551().method_1507(this.parent);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14737633);
    }
}

