/*
 * Decompiled with CFR 0.152.
 */
package com.example.gradientchat.gui;

import com.example.gradientchat.gui.ProfileManager;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ColorWheelScreen
extends class_437 {
    private static final int WHEEL_SIZE = 200;
    private static final int SELECTOR_SIZE = 4;
    private final class_437 parent;
    private final ProfileManager profileManager;
    private final Consumer<String> onColorSelected;
    private int selectedX = -1;
    private int selectedY = -1;
    private int wheelX;
    private int wheelY;

    public ColorWheelScreen(class_437 parent, ProfileManager profileManager, String currentColor, Consumer<String> onColorSelected) {
        super((class_2561)class_2561.method_43470((String)"Color Wheel"));
        this.parent = parent;
        this.profileManager = profileManager;
        this.onColorSelected = onColorSelected;
        if (currentColor != null && !currentColor.isEmpty()) {
            try {
                int color = Integer.parseInt(currentColor.replace("#", ""), 16);
                float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
                double angle = (double)(hsb[0] * 2.0f) * Math.PI;
                double radius = hsb[1] * 200.0f / 2.0f;
                this.selectedX = (int)(100.0 + radius * Math.cos(angle));
                this.selectedY = (int)(100.0 + radius * Math.sin(angle));
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid hex color: " + currentColor);
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.wheelX = this.field_22789 / 2 - 100;
        this.wheelY = this.field_22790 / 2 - 100;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> class_310.method_1551().method_1507(this.parent)).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 40, 100, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        for (int y = 0; y < 200; ++y) {
            for (int x = 0; x < 200; ++x) {
                double dx = (double)x - 100.0;
                double dy = (double)y - 100.0;
                double distance = Math.sqrt(dx * dx + dy * dy);
                if (!(distance <= 100.0)) continue;
                double angle = Math.atan2(dy, dx);
                float hue = (float)((angle + Math.PI) / (Math.PI * 2));
                float saturation = (float)(distance / 100.0);
                float brightness = 1.0f;
                int rgb = Color.HSBtoRGB(hue, saturation, brightness);
                context.method_25294(this.wheelX + x, this.wheelY + y, this.wheelX + x + 1, this.wheelY + y + 1, rgb | 0xFF000000);
            }
        }
        if (this.selectedX >= 0 && this.selectedY >= 0) {
            context.method_25294(this.wheelX + this.selectedX - 2, this.wheelY + this.selectedY - 2, this.wheelX + this.selectedX + 2, this.wheelY + this.selectedY + 2, -1);
            context.method_25294(this.wheelX + this.selectedX - 2 + 1, this.wheelY + this.selectedY - 2 + 1, this.wheelX + this.selectedX + 2 - 1, this.wheelY + this.selectedY + 2 - 1, -16777216);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            double dy;
            double dx;
            double distance;
            int wheelX = this.field_22789 / 2 - 100;
            int wheelY = this.field_22790 / 2 - 100;
            if (mouseX >= (double)wheelX && mouseX < (double)(wheelX + 200) && mouseY >= (double)wheelY && mouseY < (double)(wheelY + 200) && (distance = Math.sqrt((dx = mouseX - ((double)wheelX + 100.0)) * dx + (dy = mouseY - ((double)wheelY + 100.0)) * dy)) <= 100.0) {
                this.selectedX = (int)(mouseX - (double)wheelX);
                this.selectedY = (int)(mouseY - (double)wheelY);
                double angle = Math.atan2(dy, dx);
                float hue = (float)((angle + Math.PI) / (Math.PI * 2));
                float saturation = (float)(distance / 100.0);
                float brightness = 1.0f;
                int rgb = Color.HSBtoRGB(hue, saturation, brightness);
                String hexColor = String.format("#%06X", rgb & 0xFFFFFF);
                this.onColorSelected.accept(hexColor);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }
}

