/*
 * Decompiled with CFR 0.152.
 */
package com.example.gradientchat.gui;

import com.example.gradientchat.GradientManager;
import java.util.ArrayList;
import java.util.List;

public class ProfileManager {
    private final GradientManager gradientManager;
    private final List<Profile> profiles;
    private Profile currentProfile;

    public ProfileManager(GradientManager gradientManager) {
        this.gradientManager = gradientManager;
        this.profiles = new ArrayList<Profile>();
        Profile defaultProfile = new Profile("Default");
        this.profiles.add(defaultProfile);
        this.currentProfile = defaultProfile;
    }

    public void addProfile(String name) {
        Profile profile = new Profile(name);
        this.profiles.add(profile);
        if (this.currentProfile == null) {
            this.currentProfile = profile;
        }
    }

    public void removeProfile(Profile profile) {
        if (this.profiles.size() > 1 && this.profiles.contains(profile)) {
            this.profiles.remove(profile);
            if (this.currentProfile == profile) {
                this.currentProfile = this.profiles.get(0);
            }
        }
    }

    public void setCurrentProfile(Profile profile) {
        if (this.profiles.contains(profile)) {
            this.currentProfile = profile;
        }
    }

    public Profile getCurrentProfile() {
        return this.currentProfile;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profiles);
    }

    public GradientManager getGradientManager() {
        return this.gradientManager;
    }

    public static class Profile {
        private final String name;
        private final int[] colors;
        private boolean enabled;

        public Profile(String name) {
            this.name = name;
            this.colors = new int[]{0xFF0000, 0xFF7F00, 0xFFFF00, 65280, 255, 4915330, 9699539};
            this.enabled = true;
        }

        public String getName() {
            return this.name;
        }

        public int[] getColors() {
            return this.colors;
        }

        public void setColor(int index, int color) {
            if (index >= 0 && index < this.colors.length) {
                this.colors[index] = color;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

