/*
 * Decompiled with CFR 0.152.
 */
package net.vg.extrachests.fabric.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.vg.extrachests.util.WoodType;

public class ModModelProvider
extends FabricModelProvider {
    private final FabricDataOutput dataOutput;

    public ModModelProvider(FabricDataOutput output) {
        super(output);
        this.dataOutput = output;
    }

    public void generateBlockStateModels(class_4910 blockModelGenerators) {
    }

    public void generateItemModels(class_4915 gen) {
        this.generateChestItemModels();
        this.generateBlockstateFiles();
        this.generateBlockModelFiles();
    }

    private void generateChestItemModels() {
        try {
            for (WoodType woodType : WoodType.values()) {
                if (woodType == WoodType.OAK) continue;
                this.generateChestItemModel(woodType, false);
                this.generateChestItemModel(woodType, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate chest item models", e);
        }
    }

    private void generateChestItemModel(WoodType woodType, boolean isTrapped) throws IOException {
        JsonObject root = new JsonObject();
        JsonObject model = new JsonObject();
        JsonObject chestModel = new JsonObject();
        model.addProperty("type", "minecraft:special");
        model.addProperty("base", "minecraft:item/chest");
        chestModel.addProperty("type", "minecraft:chest");
        String textureName = woodType.getName() + (isTrapped ? "_trapped" : "");
        chestModel.addProperty("texture", "extrachests:" + textureName);
        model.add("model", (JsonElement)chestModel);
        root.add("model", (JsonElement)model);
        String fileName = woodType.getName() + (isTrapped ? "_trapped" : "") + "_chest.json";
        Path outputPath = this.dataOutput.method_45971().getParent().getParent().getParent().getParent().resolve("common").resolve("src").resolve("main").resolve("resources").resolve("assets").resolve("extrachests").resolve("items").resolve(fileName);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        String jsonString = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)root);
        Files.writeString(outputPath, (CharSequence)jsonString, new OpenOption[0]);
        System.out.println("Generated chest item model: " + fileName);
    }

    private void generateBlockstateFiles() {
        try {
            for (WoodType woodType : WoodType.values()) {
                if (woodType == WoodType.OAK) continue;
                this.generateBlockstateFile(woodType, false);
                this.generateBlockstateFile(woodType, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate blockstate files", e);
        }
    }

    private void generateBlockstateFile(WoodType woodType, boolean isTrapped) throws IOException {
        JsonObject root = new JsonObject();
        JsonObject variants = new JsonObject();
        String modelName = woodType.getName() + (isTrapped ? "_trapped" : "") + "_chest";
        String modelPath = "extrachests:block/" + modelName;
        String[] facings = new String[]{"north", "south", "west", "east"};
        String[] types = new String[]{"single", "left", "right"};
        boolean[] waterloggedStates = new boolean[]{false, true};
        int[] rotations = new int[]{0, 180, 270, 90};
        for (int f = 0; f < facings.length; ++f) {
            for (String type : types) {
                for (boolean waterlogged : waterloggedStates) {
                    String variantKey = String.format("facing=%s,type=%s,waterlogged=%s", facings[f], type, waterlogged);
                    JsonObject variantValue = new JsonObject();
                    variantValue.addProperty("model", modelPath);
                    if (rotations[f] != 0) {
                        variantValue.addProperty("y", (Number)rotations[f]);
                    }
                    variants.add(variantKey, (JsonElement)variantValue);
                }
            }
        }
        root.add("variants", (JsonElement)variants);
        String fileName = woodType.getName() + (isTrapped ? "_trapped" : "") + "_chest.json";
        Path outputPath = this.dataOutput.method_45971().getParent().getParent().getParent().getParent().resolve("common").resolve("src").resolve("main").resolve("resources").resolve("assets").resolve("extrachests").resolve("blockstates").resolve(fileName);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        String jsonString = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)root);
        Files.writeString(outputPath, (CharSequence)jsonString, new OpenOption[0]);
        System.out.println("Generated blockstate file: " + fileName);
    }

    private void generateBlockModelFiles() {
        try {
            for (WoodType woodType : WoodType.values()) {
                if (woodType == WoodType.OAK) continue;
                this.generateBlockModelFile(woodType, false);
                this.generateBlockModelFile(woodType, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate block model files", e);
        }
    }

    private void generateBlockModelFile(WoodType woodType, boolean isTrapped) throws IOException {
        JsonObject root = new JsonObject();
        root.addProperty("parent", "minecraft:block/chest");
        String fileName = woodType.getName() + (isTrapped ? "_trapped" : "") + "_chest.json";
        Path outputPath = this.dataOutput.method_45971().getParent().getParent().getParent().getParent().resolve("common").resolve("src").resolve("main").resolve("resources").resolve("assets").resolve("extrachests").resolve("models").resolve("block").resolve(fileName);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        String jsonString = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)root);
        Files.writeString(outputPath, (CharSequence)jsonString, new OpenOption[0]);
        System.out.println("Generated block model file: " + fileName);
    }
}

