/*
 * Decompiled with CFR 0.152.
 */
package net.vg.extrachests.client;

import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_10255;
import net.minecraft.class_1299;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.vg.extrachests.client.renderer.ModChestBoatRenderer;
import net.vg.extrachests.client.renderer.ModChestRenderer;
import net.vg.extrachests.client.renderer.ModTrappedChestRenderer;
import net.vg.extrachests.registry.ModChestBoatRegistries;
import net.vg.extrachests.registry.ModChestRegistries;
import net.vg.extrachests.util.Identifier;
import net.vg.extrachests.util.WoodType;

public class ExtraChestsClient {
    public static final Map<WoodType, class_5601> HULL_LAYER = Map.of(WoodType.OAK, class_5602.field_54489, WoodType.BIRCH, class_5602.field_54499, WoodType.SPRUCE, class_5602.field_54495, WoodType.JUNGLE, class_5602.field_54491, WoodType.ACACIA, class_5602.field_54487, WoodType.DARK_OAK, class_5602.field_54486, WoodType.MANGROVE, class_5602.field_54493, WoodType.CHERRY, class_5602.field_54483, WoodType.PALE_OAK, class_5602.field_54848, WoodType.BAMBOO, class_5602.field_54496);

    public static void init() {
        ExtraChestsClient.registerChestBoatEntityRenderers();
        ExtraChestsClient.registerBlockEntityRenderers();
    }

    public static void registerBlockEntityRenderers() {
        ModChestRegistries.chestTypes().forEach((wood, typeSup) -> BlockEntityRendererRegistry.register((class_2591)((class_2591)typeSup.get()), ctx -> new ModChestRenderer(ctx, false)));
        ModChestRegistries.trappedTypes().forEach((wood, typeSup) -> BlockEntityRendererRegistry.register((class_2591)((class_2591)typeSup.get()), ModTrappedChestRenderer::new));
    }

    public static void registerChestBoatEntityRenderers() {
        class_5601 water = class_5602.field_53021;
        ModChestBoatRegistries.entities().forEach((combo, typeSup) -> {
            class_5601 hull = HULL_LAYER.get((Object)combo.boatWood);
            class_2960 texture = Identifier.of(combo.texturePath());
            ExtraChestsClient.registerBoatRenderer(typeSup, hull, water, texture);
        });
    }

    private static <T extends class_10255> void registerBoatRenderer(Supplier<? extends class_1299<? extends T>> type, class_5601 hull, class_5601 water, class_2960 texture) {
        EntityRendererRegistry.register(type, ctx -> new ModChestBoatRenderer(ctx, hull, water, texture));
    }
}

