/*
 * Decompiled with CFR 0.152.
 */
package net.vg.extrachests.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10255;
import net.minecraft.class_10257;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7264;
import net.minecraft.class_7924;
import net.vg.extrachests.util.Identifier;
import net.vg.extrachests.util.WoodType;

public final class ModChestBoatRegistries {
    public static final DeferredRegister<class_1299<?>> ENTITY_TYPES = DeferredRegister.create((String)"extrachests", (class_5321)class_7924.field_41266);
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"extrachests", (class_5321)class_7924.field_41197);
    private static final List<WoodType> BOAT_WOODS = List.of(WoodType.OAK, WoodType.BIRCH, WoodType.SPRUCE, WoodType.JUNGLE, WoodType.ACACIA, WoodType.DARK_OAK, WoodType.MANGROVE, WoodType.CHERRY, WoodType.PALE_OAK, WoodType.BAMBOO);
    private static final List<WoodType> CHEST_WOODS = List.of(WoodType.BIRCH, WoodType.SPRUCE, WoodType.JUNGLE, WoodType.ACACIA, WoodType.DARK_OAK, WoodType.MANGROVE, WoodType.CHERRY, WoodType.PALE_OAK, WoodType.BAMBOO, WoodType.WARPED, WoodType.CRIMSON);
    private static final Map<ComboKey, RegistrySupplier<? extends class_1299<? extends class_10255>>> ENTITY_BY_COMBO = new LinkedHashMap<ComboKey, RegistrySupplier<? extends class_1299<? extends class_10255>>>();
    private static final Map<ComboKey, RegistrySupplier<class_1792>> ITEM_BY_COMBO = new LinkedHashMap<ComboKey, RegistrySupplier<class_1792>>();

    private ModChestBoatRegistries() {
    }

    public static Map<ComboKey, RegistrySupplier<? extends class_1299<? extends class_10255>>> entities() {
        return ENTITY_BY_COMBO;
    }

    public static Map<ComboKey, RegistrySupplier<class_1792>> items() {
        return ITEM_BY_COMBO;
    }

    public static List<WoodType> boatWoods() {
        return BOAT_WOODS;
    }

    public static List<WoodType> chestWoods() {
        return CHEST_WOODS;
    }

    public static void registerAll() {
        for (WoodType boat : BOAT_WOODS) {
            for (WoodType chest : CHEST_WOODS) {
                if (chest == WoodType.OAK) continue;
                ModChestBoatRegistries.registerOne(new ComboKey(boat, chest));
            }
        }
        ENTITY_TYPES.register();
        ITEMS.register();
    }

    private static void registerOne(ComboKey key) {
        String id = key.idPath();
        class_5321 etKey = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)Identifier.of(id));
        if (key.raft) {
            RegistrySupplier raftType = ENTITY_TYPES.register(id, () -> class_1299.class_1300.method_5903((type, level) -> new class_10257(type, level, () -> (class_1792)ModChestBoatRegistries.items().get(key).get()), (class_1311)class_1311.field_17715).method_17687(1.375f, 0.5625f).method_27299(10).method_27300(3).method_5905(etKey));
            ENTITY_BY_COMBO.put(key, (RegistrySupplier<? extends class_1299<? extends class_10255>>)raftType);
        } else {
            RegistrySupplier boatType = ENTITY_TYPES.register(id, () -> class_1299.class_1300.method_5903((type, level) -> new class_7264(type, level, () -> (class_1792)ModChestBoatRegistries.items().get(key).get()), (class_1311)class_1311.field_17715).method_17687(1.375f, 0.5625f).method_27299(10).method_27300(3).method_5905(etKey));
            ENTITY_BY_COMBO.put(key, (RegistrySupplier<? extends class_1299<? extends class_10255>>)boatType);
        }
        class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Identifier.of(id));
        RegistrySupplier itemSup = ITEMS.register(id, () -> {
            class_1299 et = (class_1299)ENTITY_BY_COMBO.get(key).get();
            return new class_1749(et, new class_1792.class_1793().method_7889(1).method_63686(itemKey));
        });
        ITEM_BY_COMBO.put(key, (RegistrySupplier<class_1792>)itemSup);
    }

    public static class_1792 vanillaBoatItem(WoodType boat) {
        return switch (boat) {
            case WoodType.OAK -> class_1802.field_8533;
            case WoodType.BIRCH -> class_1802.field_8442;
            case WoodType.SPRUCE -> class_1802.field_8486;
            case WoodType.JUNGLE -> class_1802.field_8730;
            case WoodType.ACACIA -> class_1802.field_8094;
            case WoodType.DARK_OAK -> class_1802.field_8138;
            case WoodType.MANGROVE -> class_1802.field_37531;
            case WoodType.CHERRY -> class_1802.field_42706;
            case WoodType.PALE_OAK -> class_1802.field_54620;
            case WoodType.BAMBOO -> class_1802.field_40224;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)boat));
        };
    }

    public static final class ComboKey {
        public final WoodType boatWood;
        public final WoodType chestWood;
        public final boolean raft;

        public ComboKey(WoodType boatWood, WoodType chestWood) {
            this.boatWood = boatWood;
            this.chestWood = chestWood;
            this.raft = boatWood == WoodType.BAMBOO;
        }

        public String idPath() {
            if (this.raft) {
                return "bamboo_raft_" + this.chestWood.getName() + "_chest";
            }
            return this.boatWood.getName() + "_" + this.chestWood.getName() + "_chest_boat";
        }

        public String texturePath() {
            String name = this.boatWood == WoodType.BAMBOO ? "bamboo_" + this.chestWood.getName() : this.boatWood.getName() + "_" + this.chestWood.getName();
            return "textures/entity/chest_boat/" + name + ".png";
        }
    }
}

