/*
 * Decompiled with CFR 0.152.
 */
package net.vg.extrachests.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.vg.extrachests.block.ModChestBlock;
import net.vg.extrachests.block.ModTrappedChestBlock;
import net.vg.extrachests.blockentity.ModChestBlockEntity;
import net.vg.extrachests.blockentity.ModTrappedChestBlockEntity;
import net.vg.extrachests.mixin.BlockEntityTypeInvoker;
import net.vg.extrachests.util.Identifier;
import net.vg.extrachests.util.WoodType;

public final class ModChestRegistries {
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"extrachests", (class_5321)class_7924.field_41254);
    public static final DeferredRegister<class_2591<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"extrachests", (class_5321)class_7924.field_41255);
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"extrachests", (class_5321)class_7924.field_41197);
    private static final List<WoodType> WOODS = List.of(WoodType.SPRUCE, WoodType.ACACIA, WoodType.BIRCH, WoodType.JUNGLE, WoodType.BAMBOO, WoodType.CHERRY, WoodType.CRIMSON, WoodType.DARK_OAK, WoodType.PALE_OAK, WoodType.WARPED);
    private static final Map<WoodType, RegistrySupplier<class_2591<ModChestBlockEntity>>> CHEST_TYPES = new EnumMap<WoodType, RegistrySupplier<class_2591<ModChestBlockEntity>>>(WoodType.class);
    private static final Map<WoodType, RegistrySupplier<class_2591<ModTrappedChestBlockEntity>>> TRAPPED_TYPES = new EnumMap<WoodType, RegistrySupplier<class_2591<ModTrappedChestBlockEntity>>>(WoodType.class);
    private static final Map<WoodType, RegistrySupplier<class_2248>> CHEST_BLOCKS = new EnumMap<WoodType, RegistrySupplier<class_2248>>(WoodType.class);
    private static final Map<WoodType, RegistrySupplier<class_2248>> TRAPPED_BLOCKS = new EnumMap<WoodType, RegistrySupplier<class_2248>>(WoodType.class);

    public static Map<WoodType, RegistrySupplier<class_2591<ModChestBlockEntity>>> chestTypes() {
        return CHEST_TYPES;
    }

    public static Map<WoodType, RegistrySupplier<class_2591<ModTrappedChestBlockEntity>>> trappedTypes() {
        return TRAPPED_TYPES;
    }

    public static Map<WoodType, RegistrySupplier<class_2248>> chestBlocks() {
        return CHEST_BLOCKS;
    }

    public static Map<WoodType, RegistrySupplier<class_2248>> trappedBlocks() {
        return TRAPPED_BLOCKS;
    }

    public static List<WoodType> getWOODS() {
        return WOODS;
    }

    public static void registerAll() {
        for (WoodType wood : WOODS) {
            ModChestRegistries.registerChest(wood, false);
        }
        for (WoodType wood : WOODS) {
            ModChestRegistries.registerChest(wood, true);
        }
        BLOCKS.register();
        BLOCK_ENTITY_TYPES.register();
        ITEMS.register();
    }

    private static void registerChest(WoodType wood, boolean trapped) {
        String base = wood.getName();
        String id = trapped ? base + "_trapped_chest" : base + "_chest";
        class_5321 blockKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)Identifier.of("extrachests", id));
        class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Identifier.of("extrachests", id));
        RegistrySupplier[] beRef = new RegistrySupplier[1];
        RegistrySupplier blockSup = BLOCKS.register(id, () -> {
            class_4970.class_2251 props = class_4970.class_2251.method_9637().method_63500(blockKey);
            Supplier<class_2591<? extends class_2595>> beTypeSupplier = () -> (class_2591)beRef[0].get();
            return trapped ? new ModTrappedChestBlock(wood, beTypeSupplier, props) : new ModChestBlock(wood, beTypeSupplier, props);
        });
        if (trapped) {
            RegistrySupplier beSup;
            beRef[0] = beSup = BLOCK_ENTITY_TYPES.register(id, () -> {
                class_2591 type;
                class_2591[] self = new class_2591[1];
                class_2591.class_5559 factory = (pos, state) -> new ModTrappedChestBlockEntity(self[0], pos, state);
                self[0] = type = BlockEntityTypeInvoker.invokeNew(factory, Set.of((class_2248)blockSup.get()));
                return type;
            });
            TRAPPED_TYPES.put(wood, (RegistrySupplier<class_2591<ModTrappedChestBlockEntity>>)beSup);
            TRAPPED_BLOCKS.put(wood, (RegistrySupplier<class_2248>)blockSup);
        } else {
            RegistrySupplier beSup;
            beRef[0] = beSup = BLOCK_ENTITY_TYPES.register(id, () -> {
                class_2591 type;
                class_2591[] self = new class_2591[1];
                class_2591.class_5559 factory = (pos, state) -> new ModChestBlockEntity(self[0], pos, state);
                self[0] = type = BlockEntityTypeInvoker.invokeNew(factory, Set.of((class_2248)blockSup.get()));
                return type;
            });
            CHEST_TYPES.put(wood, (RegistrySupplier<class_2591<ModChestBlockEntity>>)beSup);
            CHEST_BLOCKS.put(wood, (RegistrySupplier<class_2248>)blockSup);
        }
        ITEMS.register(id, () -> new class_1747((class_2248)blockSup.get(), new class_1792.class_1793().method_63686(itemKey)));
    }

    private ModChestRegistries() {
    }
}

