/*
 * Decompiled with CFR 0.152.
 */
package net.vg.extrachests.util;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum WoodType {
    OAK("oak"),
    BIRCH("birch"),
    SPRUCE("spruce"),
    JUNGLE("jungle"),
    ACACIA("acacia"),
    DARK_OAK("dark_oak"),
    MANGROVE("mangrove"),
    CHERRY("cherry"),
    PALE_OAK("pale_oak"),
    BAMBOO("bamboo"),
    CRIMSON("crimson"),
    WARPED("warped");

    private final String name;

    private WoodType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey(boolean isTrapped, boolean isDouble) {
        StringBuilder key = new StringBuilder("container.");
        key.append("extrachests").append(".");
        key.append(this.name);
        if (isTrapped) {
            key.append("_trapped");
        }
        key.append("_chest");
        if (isDouble) {
            key.append("Double");
        }
        return key.toString();
    }

    public String getTextureLocation(boolean isTrapped, String variant) {
        StringBuilder texture = new StringBuilder(this.name);
        if (isTrapped) {
            texture.append("_trapped");
        }
        if (variant != null && !variant.isEmpty()) {
            texture.append("_").append(variant);
        }
        return texture.toString();
    }

    public String getDisplayName() {
        return Arrays.stream(this.name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    public String getBlockTranslationKey(boolean isTrapped) {
        StringBuilder key = new StringBuilder("block.");
        key.append("extrachests").append(".");
        key.append(this.name);
        if (isTrapped) {
            key.append("_trapped");
        }
        key.append("_chest");
        return key.toString();
    }

    public String getItemTranslationKey(boolean isTrapped) {
        StringBuilder key = new StringBuilder("item.");
        key.append("extrachests").append(".");
        key.append(this.name);
        if (isTrapped) {
            key.append("_trapped");
        }
        key.append("_chest");
        return key.toString();
    }
}

