/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.gospi.mountsofmayhem.client.model.ModelNautilus;
import net.gospi.mountsofmayhem.client.model.ModelNautilusBaby;
import net.gospi.mountsofmayhem.client.model.animations.NautilusAnimation;
import net.gospi.mountsofmayhem.client.model.animations.NautilusBabyAnimation;
import net.gospi.mountsofmayhem.entity.NautilusEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;

public class NautilusRenderer
extends MobRenderer<NautilusEntity, AnimatedModel> {
    public NautilusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<NautilusEntity, AnimatedModel>(this, (RenderLayerParent)this){

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, NautilusEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                AnimatedModel model = (AnimatedModel)this.getParentModel();
                ResourceLocation tex = model.getCurrentTexture(entity);
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)tex));
                if (entity.isBaby()) {
                    model.babyModel.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), 0xFFFFFF);
                } else {
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<NautilusEntity, AnimatedModel>(this, (RenderLayerParent)this){

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, NautilusEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                NautilusEntity s;
                if (entity instanceof Saddleable && (s = entity).isSaddled() && !entity.isBaby()) {
                    AnimatedModel model = (AnimatedModel)this.getParentModel();
                    ResourceLocation tex = ResourceLocation.parse((String)"mounts_of_mayhem:textures/entities/nautilus_saddle.png");
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)tex));
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(NautilusEntity entity) {
        return ((AnimatedModel)this.getModel()).getCurrentTexture(entity);
    }

    public void render(NautilusEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            AnimatedModel model = (AnimatedModel)this.getModel();
            ResourceLocation tex = model.getCurrentTexture(entity);
            VertexConsumer vc = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)tex));
            poseStack.pushPose();
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0f, -1.5f, 0.0f);
            model.babyModel.setupAnim(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f);
            model.babyModel.renderToBuffer(poseStack, vc, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), 0xFFFFFF);
            poseStack.popPose();
            return;
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    static final class AnimatedModel
    extends ModelNautilus<NautilusEntity> {
        private final ModelPart root;
        private final HierarchicalModel<NautilusEntity> animator = new HierarchicalModel<NautilusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(NautilusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, NautilusAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, NautilusBabyAnimation.idle, ageInTicks, 1.0f);
            }
        };
        private final ModelNautilusBaby<NautilusEntity> babyModel;

        public AnimatedModel(EntityRendererProvider.Context ctx) {
            super(ctx.bakeLayer(ModelNautilus.LAYER_LOCATION));
            this.root = this.nautilus;
            this.babyModel = new ModelNautilusBaby(ctx.bakeLayer(ModelNautilusBaby.LAYER_LOCATION));
        }

        @Override
        public void setupAnim(NautilusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }

        ResourceLocation getCurrentTexture(NautilusEntity entity) {
            if (entity.isBaby()) {
                return ResourceLocation.parse((String)"mounts_of_mayhem:textures/entities/nautilus_baby.png");
            }
            return ResourceLocation.parse((String)"mounts_of_mayhem:textures/entities/nautilus.png");
        }
    }
}

