/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.entity;

import java.util.function.Predicate;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModEntities;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModMobEffects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class NautilusEntity
extends Animal
implements Saddleable {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    private static final EntityDataAccessor<Boolean> DATA_TAMED = SynchedEntityData.defineId(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.defineId(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public NautilusEntity(EntityType<NautilusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (NautilusEntity.this.isInWater() && !NautilusEntity.this.isVehicle()) {
                    NautilusEntity.this.setDeltaMovement(NautilusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !NautilusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - NautilusEntity.this.getX();
                    double dy = this.wantedY - NautilusEntity.this.getY();
                    double dz = this.wantedZ - NautilusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * NautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    NautilusEntity.this.setYRot(this.rotlerp(NautilusEntity.this.getYRot(), f, 10.0f));
                    NautilusEntity.this.yBodyRot = NautilusEntity.this.getYRot();
                    NautilusEntity.this.yHeadRot = NautilusEntity.this.getYRot();
                    if (NautilusEntity.this.isInWater()) {
                        NautilusEntity.this.setSpeed((float)NautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        NautilusEntity.this.setXRot(this.rotlerp(NautilusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(NautilusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        NautilusEntity.this.setZza(f3 * f1);
                        NautilusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        NautilusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    NautilusEntity.this.setSpeed(0.0f);
                    NautilusEntity.this.setYya(0.0f);
                    NautilusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TAMED, (Object)false);
        builder.define(DATA_SADDLED, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUFFERFISH}), false));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)Items.NAUTILUS_SHELL));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        boolean isBaby = this.isBaby();
        if (held.is(Items.PUFFERFISH) && !this.isTamed()) {
            if (!player.getAbilities().instabuild) {
                held.shrink(1);
            }
            if (this.level().isClientSide()) {
                return InteractionResult.sidedSuccess((boolean)true);
            }
            if (this.getRandom().nextFloat() < 0.6f) {
                this.setTamed(true);
                this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.burp")), 1.5f, 1.0f);
            } else {
                this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.camel.eat")), 0.8f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (held.is(Items.SADDLE) && !isBaby && this.isTamed() && !this.isSaddled()) {
            if (this.level().isClientSide()) {
                return InteractionResult.sidedSuccess((boolean)true);
            }
            if (!player.getAbilities().instabuild) {
                held.shrink(1);
            }
            this.setSaddled(true);
            this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.horse.saddle")), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!isBaby && this.isTamed() && this.isSaddled() && !this.isVehicle()) {
            if (this.level().isClientSide()) {
                return InteractionResult.sidedSuccess((boolean)true);
            }
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        Entity rider;
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(true, this.tickCount);
        }
        if (!this.getPassengers().isEmpty() && (rider = (Entity)this.getPassengers().get(0)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)rider;
            living.addEffect(new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)MountsOfMayhemModMobEffects.BREATH_OF_THE_NAUTILUS.get())), 60, 0));
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        NautilusEntity retval = (NautilusEntity)((EntityType)MountsOfMayhemModEntities.NAUTILUS.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.PUFFERFISH), new ItemStack((ItemLike)Items.PUFFERFISH_BUCKET), new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.COD_BUCKET), new ItemStack((ItemLike)Items.SALMON), new ItemStack((ItemLike)Items.SALMON_BUCKET), new ItemStack((ItemLike)Items.TROPICAL_FISH), new ItemStack((ItemLike)Items.TROPICAL_FISH_BUCKET)}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void travel(Vec3 dir) {
        Entity rider;
        Entity entity = rider = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle() && rider instanceof LivingEntity) {
            float vertical;
            boolean isMoving;
            LivingEntity passenger = (LivingEntity)rider;
            this.setYRot(rider.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(rider.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = rider.getYRot();
            this.yHeadRot = rider.getYRot();
            float forward = passenger.zza;
            float strafe = passenger.xxa;
            float pitch = passenger.getXRot();
            boolean bl = isMoving = Math.abs(forward) > 0.05f || Math.abs(strafe) > 0.05f;
            if (isMoving) {
                vertical = pitch > 10.0f ? -Mth.clamp((float)((pitch - 10.0f) / 60.0f), (float)0.0f, (float)1.0f) : (pitch < -10.0f ? Mth.clamp((float)((-10.0f - pitch) / 60.0f), (float)0.0f, (float)1.0f) : 0.0f);
            } else {
                vertical = 0.0f;
                if (this.isInWater()) {
                    Vec3 v = this.getDeltaMovement();
                    this.setDeltaMovement(v.x * 0.8, 0.0, v.z * 0.8);
                }
            }
            float speedBoost = 5.0f;
            this.setSpeed((float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)speedBoost));
            if (this.isInWater()) {
                float verticalBoost = 5.0f;
                super.travel(new Vec3((double)strafe, (double)(vertical * verticalBoost), (double)forward));
            } else {
                super.travel(Vec3.ZERO);
            }
            double d1 = this.getX() - this.xo;
            double d0 = this.getZ() - this.zo;
            float f1 = (float)Math.sqrt(d1 * d1 + d0 * d0) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f1 - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(dir);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData) {
        SpawnGroupData result = super.finalizeSpawn(world, difficulty, reason, spawnData);
        double max = 10 + this.getRandom().nextInt(5);
        AttributeInstance attr = this.getAttribute(Attributes.MAX_HEALTH);
        if (attr != null) {
            attr.setBaseValue(max);
        }
        this.setHealth((float)max);
        return result;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MountsOfMayhemModEntities.NAUTILUS.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.8);
        builder = builder.add(Attributes.MAX_HEALTH, 12.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }

    public boolean isTamed() {
        return (Boolean)this.entityData.get(DATA_TAMED);
    }

    public void setTamed(boolean tamed) {
        this.entityData.set(DATA_TAMED, (Object)tamed);
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(DATA_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(DATA_SADDLED, (Object)saddled);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Tamed", this.isTamed());
        tag.putBoolean("Saddled", this.isSaddled());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setTamed(tag.getBoolean("Tamed"));
        this.setSaddled(tag.getBoolean("Saddled"));
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby() && this.isTamed();
    }

    public void equipSaddle(ItemStack stack, SoundSource sound) {
        this.setSaddled(true);
        this.playSound(SoundEvents.HORSE_SADDLE, 1.0f, 1.0f);
    }
}

