/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.entity;

import net.gospi.mountsofmayhem.init.MountsOfMayhemModEntities;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class NautilusEntity
extends Animal
implements Saddleable {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    private static final EntityDataAccessor<Boolean> DATA_TAMED = SynchedEntityData.m_135353_(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public NautilusEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<NautilusEntity>)((EntityType)MountsOfMayhemModEntities.NAUTILUS.get()), world);
    }

    public NautilusEntity(EntityType<NautilusEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 3;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (NautilusEntity.this.m_20069_() && !NautilusEntity.this.m_20160_()) {
                    NautilusEntity.this.m_20256_(NautilusEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !NautilusEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - NautilusEntity.this.m_20185_();
                    double dy = this.f_24976_ - NautilusEntity.this.m_20186_();
                    double dz = this.f_24977_ - NautilusEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * NautilusEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    NautilusEntity.this.m_146922_(this.m_24991_(NautilusEntity.this.m_146908_(), f, 10.0f));
                    NautilusEntity.this.f_20883_ = NautilusEntity.this.m_146908_();
                    NautilusEntity.this.f_20885_ = NautilusEntity.this.m_146908_();
                    if (NautilusEntity.this.m_20069_()) {
                        NautilusEntity.this.m_7910_((float)NautilusEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        NautilusEntity.this.m_146926_(this.m_24991_(NautilusEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(NautilusEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        NautilusEntity.this.m_21564_(f3 * f1);
                        NautilusEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        NautilusEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    NautilusEntity.this.m_7910_(0.0f);
                    NautilusEntity.this.m_21567_(0.0f);
                    NautilusEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TAMED, (Object)false);
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42529_}), false));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean recentlyHitIn) {
        super.m_7472_(source, lootingMultiplier, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42715_));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        boolean isBaby = this.m_6162_();
        if (held.m_150930_(Items.f_42529_) && !this.isTamed()) {
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.m_19078_((boolean)true);
            }
            if (this.m_217043_().m_188501_() < 0.6f) {
                this.setTamed(true);
                this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.cat.purr")), 1.0f, 1.0f);
            } else {
                this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.generic.eat")), 0.8f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        if (held.m_150930_(Items.f_42450_) && !isBaby && this.isTamed() && !this.m_6254_()) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.m_19078_((boolean)true);
            }
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            this.setSaddled(true);
            this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.horse.saddle")), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!isBaby && this.isTamed() && this.m_6254_() && !this.m_20160_()) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.m_19078_((boolean)true);
            }
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        Entity rider;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.animationState0.m_246184_(true, this.f_19797_);
            this.animationState1.m_246184_(true, this.f_19797_);
        }
        if (!this.m_20197_().isEmpty() && (rider = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)rider;
            living.m_7292_(new MobEffectInstance((MobEffect)MountsOfMayhemModMobEffects.BREATH_OF_THE_NAUTILUS.get(), 40, 0));
        }
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        NautilusEntity retval = (NautilusEntity)((EntityType)MountsOfMayhemModEntities.NAUTILUS.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42529_), new ItemStack((ItemLike)Items.f_42456_), new ItemStack((ItemLike)Items.f_42526_), new ItemStack((ItemLike)Items.f_42458_), new ItemStack((ItemLike)Items.f_42527_), new ItemStack((ItemLike)Items.f_42457_), new ItemStack((ItemLike)Items.f_42528_), new ItemStack((ItemLike)Items.f_42459_)}).test(stack);
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 dir) {
        Entity rider;
        Entity entity = rider = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && rider instanceof LivingEntity) {
            float vertical;
            boolean isMoving;
            LivingEntity passenger = (LivingEntity)rider;
            this.m_146922_(rider.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(rider.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = rider.m_146908_();
            this.f_20885_ = rider.m_146908_();
            float forward = passenger.f_20902_;
            float strafe = passenger.f_20900_;
            float pitch = passenger.m_146909_();
            boolean bl = isMoving = Math.abs(forward) > 0.05f || Math.abs(strafe) > 0.05f;
            if (isMoving) {
                vertical = pitch > 10.0f ? -Mth.m_14036_((float)((pitch - 10.0f) / 60.0f), (float)0.0f, (float)1.0f) : (pitch < -10.0f ? Mth.m_14036_((float)((-10.0f - pitch) / 60.0f), (float)0.0f, (float)1.0f) : 0.0f);
            } else {
                vertical = 0.0f;
                if (this.m_20069_()) {
                    Vec3 v = this.m_20184_();
                    this.m_20334_(v.f_82479_ * 0.8, 0.0, v.f_82481_ * 0.8);
                }
            }
            float speedBoost = 2.0f;
            this.m_7910_((float)(this.m_21133_(Attributes.f_22279_) * (double)speedBoost));
            if (this.m_20069_()) {
                float verticalBoost = 2.0f;
                super.m_7023_(new Vec3((double)strafe, (double)(vertical * verticalBoost), (double)forward));
            } else {
                super.m_7023_(Vec3.f_82478_);
            }
            double d1 = this.m_20185_() - this.f_19854_;
            double d0 = this.m_20189_() - this.f_19856_;
            float f1 = (float)Math.sqrt(d1 * d1 + d0 * d0) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        SpawnGroupData result = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        double max = 10 + this.m_217043_().m_188503_(5);
        AttributeInstance attr = this.m_21051_(Attributes.f_22276_);
        if (attr != null) {
            attr.m_22100_(max);
        }
        this.m_21153_((float)max);
        return result;
    }

    public static void init() {
    }

    public static void init(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)MountsOfMayhemModEntities.NAUTILUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_), SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.8);
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 8.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.7);
        return builder;
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(DATA_TAMED, (Object)tamed);
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddled);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Tamed", this.isTamed());
        tag.m_128379_("Saddled", this.m_6254_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTamed(tag.m_128471_("Tamed"));
        this.setSaddled(tag.m_128471_("Saddled"));
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.isTamed();
    }

    public void m_5853_(SoundSource sound) {
        this.setSaddled(true);
        this.m_5496_(SoundEvents.f_12034_, 1.0f, 1.0f);
    }
}

