/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.event;

import java.util.Set;
import net.gospi.mountsofmayhem.entity.ZombieNautilusEntity;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mounts_of_mayhem", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ZombieNautilusRaiderSpawner {
    private static final Set<ResourceLocation> OCEAN_BIOMES = Set.of(new ResourceLocation("minecraft:ocean"), new ResourceLocation("minecraft:deep_ocean"), new ResourceLocation("minecraft:cold_ocean"), new ResourceLocation("minecraft:deep_cold_ocean"), new ResourceLocation("minecraft:lukewarm_ocean"), new ResourceLocation("minecraft:deep_lukewarm_ocean"), new ResourceLocation("minecraft:warm_ocean"), new ResourceLocation("minecraft:deep_frozen_ocean"));

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        ZombieNautilusEntity nautilus;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof Drowned)) {
            return;
        }
        Drowned drowned = (Drowned)entity;
        if (drowned.getPersistentData().m_128471_("MountedOnNautilus")) {
            return;
        }
        if (!drowned.m_20069_()) {
            return;
        }
        if (!ZombieNautilusRaiderSpawner.isOceanBiome(level2, drowned.m_20183_())) {
            return;
        }
        if (level2.m_213780_().m_188501_() > 0.35f) {
            return;
        }
        drowned.getPersistentData().m_128379_("MountedOnNautilus", true);
        float random = level2.m_213780_().m_188501_();
        ItemStack weapon = random < 0.4f ? new ItemStack((ItemLike)Items.f_42713_) : (random < 0.7f ? new ItemStack((ItemLike)Items.f_42715_) : ItemStack.f_41583_);
        if (!weapon.m_41619_()) {
            drowned.m_8061_(EquipmentSlot.MAINHAND, weapon);
            drowned.m_21409_(EquipmentSlot.MAINHAND, 0.05f);
        }
        if ((nautilus = (ZombieNautilusEntity)((EntityType)MountsOfMayhemModEntities.ZOMBIE_NAUTILUS.get()).m_20615_((Level)level2)) != null) {
            BlockPos pos = drowned.m_20183_();
            nautilus.m_7678_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), drowned.m_146908_(), drowned.m_146909_());
            nautilus.m_21530_();
            level2.m_7967_((Entity)nautilus);
            drowned.m_21530_();
            drowned.m_21573_().m_26573_();
            drowned.m_6710_(null);
            if (drowned.m_7998_((Entity)nautilus, true)) {
                System.out.println("Drowned successfully mounted Zombie Nautilus");
                nautilus.m_21530_();
                drowned.m_21530_();
            }
        }
    }

    private static boolean isOceanBiome(ServerLevel level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        ResourceLocation key = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        return key != null && OCEAN_BIOMES.contains(key);
    }
}

