/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.event;

import java.util.Set;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mounts_of_mayhem", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ZombieRaiderSpawner {
    private static final Set<ResourceLocation> OPEN_BIOMES = Set.of(new ResourceLocation("minecraft:plains"), new ResourceLocation("minecraft:sunflower_plains"), new ResourceLocation("minecraft:meadow"), new ResourceLocation("minecraft:savanna"), new ResourceLocation("minecraft:savanna_plateau"));

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (zombie.getPersistentData().m_128471_("MountsOfMayhemSpawned")) {
            return;
        }
        if (!level2.m_46462_()) {
            return;
        }
        if (!ZombieRaiderSpawner.isOpenBiome(level2, zombie.m_20183_())) {
            return;
        }
        if (level2.m_213780_().m_188501_() > 0.15f) {
            return;
        }
        zombie.getPersistentData().m_128379_("MountsOfMayhemSpawned", true);
        zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MountsOfMayhemModItems.IRON_SPEAR.get()));
        zombie.m_21409_(EquipmentSlot.MAINHAND, 0.05f);
        ZombieHorse horse = (ZombieHorse)EntityType.f_20502_.m_20615_((Level)level2);
        if (horse != null) {
            BlockPos pos = zombie.m_20183_();
            horse.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, zombie.m_146908_(), zombie.m_146909_());
            horse.m_21530_();
            horse.m_30651_(true);
            level2.m_7967_((Entity)horse);
            if (zombie.m_7998_((Entity)horse, true)) {
                System.out.println("Zombie successfully mounted horse");
            }
        }
    }

    private static boolean isOpenBiome(ServerLevel level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        ResourceLocation key = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        return key != null && OPEN_BIOMES.contains(key);
    }
}

