/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class SpearItem
extends Item {
    private final int maxHoldTicks;
    private final int reloadTicks;
    private final double baseDamage;
    private final double speedMultiplier;
    private final double vehicleBonus;
    private static final UUID AIM_SPEED_MOD_ID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final AttributeModifier AIM_SPEED_MODIFIER_1 = new AttributeModifier(AIM_SPEED_MOD_ID, "Spear aim speed", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier AIM_SPEED_MODIFIER_2 = new AttributeModifier(AIM_SPEED_MOD_ID, "Spear aim speed", 1.25, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public static Item.Properties createSpearProperties(int durability) {
        return new Item.Properties().m_41503_(durability);
    }

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks, double baseDamage, double speedMultiplier, double vehicleBonus) {
        super(properties);
        this.maxHoldTicks = maxHoldTicks;
        this.reloadTicks = reloadTicks;
        this.baseDamage = baseDamage;
        this.speedMultiplier = speedMultiplier;
        this.vehicleBonus = vehicleBonus;
    }

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks) {
        this(properties, maxHoldTicks, reloadTicks, SpearItem.getDefaultBaseDamage(), SpearItem.getDefaultSpeedMultiplier(), SpearItem.getDefaultVehicleBonus());
    }

    private static double getDefaultBaseDamage() {
        return 4.0;
    }

    private static double getDefaultSpeedMultiplier() {
        return 1.4;
    }

    private static double getDefaultVehicleBonus() {
        return 1.25;
    }

    private double getMaterialBaseDamage() {
        String className;
        switch (className = ((Object)((Object)this)).getClass().getSimpleName()) {
            case "WoodenSpearItem": {
                return 2.0;
            }
            case "StoneSpearItem": {
                return 3.0;
            }
            case "CopperSpearItem": {
                return 3.5;
            }
            case "GoldenSpearItem": {
                return 2.5;
            }
            case "IronSpearItem": {
                return 4.0;
            }
            case "DiamondSpearItem": {
                return 5.0;
            }
            case "NetheriteSpearItem": {
                return 6.0;
            }
        }
        return 4.0;
    }

    private double getMaterialSpeedMultiplier() {
        String className;
        switch (className = ((Object)((Object)this)).getClass().getSimpleName()) {
            case "WoodenSpearItem": {
                return 1.0;
            }
            case "StoneSpearItem": {
                return 1.2;
            }
            case "CopperSpearItem": {
                return 1.3;
            }
            case "GoldenSpearItem": {
                return 0.8;
            }
            case "IronSpearItem": {
                return 1.4;
            }
            case "DiamondSpearItem": {
                return 1.6;
            }
            case "NetheriteSpearItem": {
                return 1.8;
            }
        }
        return 1.4;
    }

    private double getMaterialVehicleBonus() {
        String className;
        switch (className = ((Object)((Object)this)).getClass().getSimpleName()) {
            case "WoodenSpearItem": {
                return 1.0;
            }
            case "StoneSpearItem": {
                return 1.1;
            }
            case "CopperSpearItem": {
                return 1.15;
            }
            case "GoldenSpearItem": {
                return 0.9;
            }
            case "IronSpearItem": {
                return 1.25;
            }
            case "DiamondSpearItem": {
                return 1.4;
            }
            case "NetheriteSpearItem": {
                return 1.5;
            }
        }
        return 1.25;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return this.maxHoldTicks;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        AttributeInstance move = player.m_21051_(Attributes.f_22279_);
        if (move != null && !this.hasSpeedModifier(move)) {
            move.m_22118_(AIM_SPEED_MODIFIER_1);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int remainingUseDuration) {
        LivingEntity target;
        int elapsed;
        if (level.f_46443_) {
            return;
        }
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (player.m_36335_().m_41519_((Item)this)) {
            player.m_5810_();
            return;
        }
        AttributeInstance move = player.m_21051_(Attributes.f_22279_);
        if (move != null && !this.hasSpeedModifier(move)) {
            move.m_22118_(AIM_SPEED_MODIFIER_2);
        }
        if ((elapsed = this.m_8105_(stack) - remainingUseDuration) < 0) {
            elapsed = 0;
        }
        if (elapsed > 0 && (target = SpearItem.findTargetInFront(player, 5.0)) != null && target.m_6084_()) {
            boolean moving;
            double speed = this.getMovementSpeed(player);
            float damage = this.computeDamage(speed, player);
            double dist = player.m_20270_((Entity)target);
            boolean inRange = dist <= 3.5;
            boolean bl = moving = speed >= 0.12;
            if (damage > 0.0f && inRange && moving) {
                target.m_6469_(player.m_269291_().m_269075_(player), damage);
                Vec3 dir = player.m_20252_(1.0f);
                double materialSpeedMultiplier = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.speedMultiplier : this.getMaterialSpeedMultiplier();
                double kb = Math.min(0.3 + this.getMovementSpeed(player) * 0.8 * materialSpeedMultiplier, 0.8);
                target.m_5997_(dir.f_82479_ * kb, 0.08, dir.f_82481_ * kb);
                stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21166_(player.m_7655_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                this.removeSpeedModifier(player);
                player.m_5810_();
                player.m_36335_().m_41524_((Item)this, this.reloadTicks);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        if (level.f_46443_) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            int elapsed = this.m_8105_(stack) - timeLeft;
            if (elapsed >= this.maxHoldTicks) {
                player.m_36335_().m_41524_((Item)this, this.reloadTicks);
            }
            this.removeSpeedModifier(player);
        }
    }

    private boolean hasSpeedModifier(AttributeInstance attribute) {
        return attribute.m_22111_(AIM_SPEED_MOD_ID) != null;
    }

    private void removeSpeedModifier(Player player) {
        AttributeInstance move = player.m_21051_(Attributes.f_22279_);
        if (move != null && this.hasSpeedModifier(move)) {
            move.m_22120_(AIM_SPEED_MOD_ID);
        }
    }

    private double getMovementSpeed(Player player) {
        Vec3 v = player.m_20184_();
        double base = v.m_82553_();
        if (player.m_20159_() && player.m_20202_() != null) {
            Entity vehicle = player.m_20202_();
            Vec3 vehicleVel = vehicle.m_20184_();
            double vehicleSpeed = vehicleVel.m_82553_();
            double materialVehicleBonus = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.vehicleBonus : this.getMaterialVehicleBonus();
            double vehicleMultiplier = 1.0;
            vehicleMultiplier = vehicle instanceof AbstractHorse ? 1.55 * materialVehicleBonus : (vehicle instanceof Camel ? 1.45 * materialVehicleBonus : (vehicle instanceof AbstractMinecart ? 1.35 * materialVehicleBonus : (vehicle instanceof Boat ? 1.35 * materialVehicleBonus : (vehicle instanceof Phantom ? 2.05 * materialVehicleBonus : 1.35 * materialVehicleBonus))));
            base = Math.max(base, vehicleSpeed * vehicleMultiplier);
        }
        if (player.m_20159_() && base < 0.1) {
            double materialVehicleBonus = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.vehicleBonus : this.getMaterialVehicleBonus();
            base = 0.325 * materialVehicleBonus;
        }
        return base;
    }

    private float computeDamage(double speed, Player player) {
        double minDamage;
        double materialBaseDamage = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.baseDamage : this.getMaterialBaseDamage();
        double materialSpeedMultiplier = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.speedMultiplier : this.getMaterialSpeedMultiplier();
        double materialVehicleBonus = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.vehicleBonus : this.getMaterialVehicleBonus();
        double speedInBlocksPerSecond = speed * 20.0;
        double damage = (materialBaseDamage + speedInBlocksPerSecond * 0.65) * materialSpeedMultiplier;
        if (player.m_20159_()) {
            damage *= materialVehicleBonus;
        }
        if (damage < (minDamage = materialBaseDamage * 0.75) && speed >= 0.12) {
            damage = minDamage;
        }
        return (float)damage;
    }

    private static LivingEntity findTargetInFront(Player player, double range) {
        Vec3 eye = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = eye.m_82549_(look.m_82490_(range));
        AABB box = new AABB(eye, end).m_82400_(0.5);
        List candidates = player.m_9236_().m_6249_((Entity)player, box, e -> e instanceof LivingEntity && e != player);
        LivingEntity best = null;
        double bestDot = 0.9;
        for (Entity e2 : candidates) {
            Vec3 to = e2.m_20182_().m_82520_(0.0, (double)e2.m_20206_() * 0.5, 0.0).m_82546_(eye).m_82541_();
            double dot = to.m_82526_(look);
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            best = (LivingEntity)e2;
        }
        return best;
    }
}

