/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.event;

import java.util.Set;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="mounts_of_mayhem", bus=EventBusSubscriber.Bus.GAME)
public class ZombieRaiderSpawner {
    private static final Set<ResourceLocation> OPEN_BIOMES = Set.of(ResourceLocation.parse((String)"minecraft:plains"), ResourceLocation.parse((String)"minecraft:sunflower_plains"), ResourceLocation.parse((String)"minecraft:meadow"), ResourceLocation.parse((String)"minecraft:savanna"), ResourceLocation.parse((String)"minecraft:savanna_plateau"));

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (zombie.getPersistentData().getBoolean("MountsOfMayhemSpawned")) {
            return;
        }
        if (!level2.isNight()) {
            return;
        }
        if (!ZombieRaiderSpawner.isOpenBiome(level2, zombie.blockPosition())) {
            return;
        }
        if (level2.getRandom().nextFloat() > 0.2f) {
            return;
        }
        zombie.getPersistentData().putBoolean("MountsOfMayhemSpawned", true);
        zombie.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MountsOfMayhemModItems.IRON_SPEAR.get()));
        zombie.setDropChance(EquipmentSlot.MAINHAND, 0.05f);
        ZombieHorse horse = (ZombieHorse)EntityType.ZOMBIE_HORSE.create((Level)level2);
        if (horse != null) {
            BlockPos pos = zombie.blockPosition();
            horse.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, zombie.getYRot(), zombie.getXRot());
            horse.setPersistenceRequired();
            horse.setTamed(true);
            level2.addFreshEntity((Entity)horse);
            if (zombie.startRiding((Entity)horse, true)) {
                System.out.println("Zombie successfully mounted horse");
            }
        }
    }

    private static boolean isOpenBiome(ServerLevel level, BlockPos pos) {
        Biome biome = (Biome)level.getBiome(pos).value();
        ResourceLocation key = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
        return key != null && OPEN_BIOMES.contains(key);
    }
}

