/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.mixin;

import java.util.Map;
import net.gospi.mountsofmayhem.MountsOfMayhemModPlayerAnimationAPI;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerAnimationMixin<T extends LivingEntity> {
    private String master = null;

    @Inject(method={"setupAnim"}, at={@At(value="HEAD")})
    public void setupPivot(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        Player player_;
        if (this.master == null) {
            this.master = "mounts_of_mayhem";
        }
        PlayerModel model = (PlayerModel)this;
        Player player = null;
        if (!(entityIn instanceof Player)) {
            return;
        }
        player = player_ = (Player)entityIn;
        MountsOfMayhemModPlayerAnimationAPI.PlayerAnimation animation = MountsOfMayhemModPlayerAnimationAPI.active_animations.get(player);
        if (animation == null) {
            return;
        }
        if (animation.bones.get("left_arm") != null || animation.bones.get("torso") != null || animation.bones.get("right_arm") != null) {
            model.attackTime = 0.0f;
        }
        model.crouching = false;
        this.resetModelPose(model);
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        float animationProgress;
        MountsOfMayhemModPlayerAnimationAPI.PlayerAnimation animation;
        Player player_;
        if (!this.master.equals("mounts_of_mayhem")) {
            if (!MountsOfMayhemModPlayerAnimationAPI.animations.isEmpty()) {
                MountsOfMayhemModPlayerAnimationAPI.animations.clear();
            }
            return;
        }
        PlayerModel model = (PlayerModel)this;
        Player player = null;
        if (!(entityIn instanceof Player)) {
            return;
        }
        player = player_ = (Player)entityIn;
        CompoundTag data = player.getPersistentData();
        String playingAnimation = data.getString("PlayerCurrentAnimation");
        boolean overrideAnimation = data.getBoolean("OverrideCurrentAnimation");
        if (data.getBoolean("ResetPlayerAnimation")) {
            data.remove("ResetPlayerAnimation");
            this.resetModelPose(model);
            MountsOfMayhemModPlayerAnimationAPI.active_animations.put(player, null);
        }
        if (playingAnimation.isEmpty()) {
            return;
        }
        if (overrideAnimation) {
            data.putBoolean("OverrideCurrentAnimation", false);
            data.remove("PlayerAnimationProgress");
            MountsOfMayhemModPlayerAnimationAPI.active_animations.put(player, null);
        }
        if ((animation = MountsOfMayhemModPlayerAnimationAPI.active_animations.get(player)) == null) {
            animation = MountsOfMayhemModPlayerAnimationAPI.animations.get(playingAnimation);
            MountsOfMayhemModPlayerAnimationAPI.active_animations.put(player, animation);
        }
        if (!data.contains("PlayerAnimationProgress")) {
            animationProgress = 0.0f;
            data.putFloat("PlayerAnimationProgress", animationProgress);
            data.putFloat("LastTickTime", ageInTicks);
        } else {
            animationProgress = data.getFloat("PlayerAnimationProgress");
            float lastTickTime = data.getFloat("LastTickTime");
            float deltaTime = (ageInTicks - lastTickTime) / 20.0f;
            data.putFloat("PlayerAnimationProgress", animationProgress += deltaTime);
            data.putFloat("LastTickTime", ageInTicks);
            if (animationProgress >= animation.length) {
                if (!animation.hold_on_last_frame && !animation.loop) {
                    data.remove("PlayerCurrentAnimation");
                    data.remove("PlayerAnimationProgress");
                    data.putBoolean("ResetPlayerAnimation", true);
                    MountsOfMayhemModPlayerAnimationAPI.active_animations.put(player, null);
                    animationProgress = animation.length;
                } else if (animation.hold_on_last_frame) {
                    data.putFloat("PlayerAnimationProgress", animation.length);
                } else if (animation.loop) {
                    data.remove("PlayerAnimationProgress");
                }
            }
        }
        for (Map.Entry<String, MountsOfMayhemModPlayerAnimationAPI.PlayerBone> entry : animation.bones.entrySet()) {
            Vec3 scale;
            Vec3 position;
            String boneName = entry.getKey();
            MountsOfMayhemModPlayerAnimationAPI.PlayerBone bone = entry.getValue();
            ModelPart modelPart = this.getModelPart(model, boneName);
            if (modelPart == null) continue;
            Vec3 rotation = MountsOfMayhemModPlayerAnimationAPI.PlayerBone.interpolate(bone.rotations, animationProgress);
            if (rotation != null) {
                modelPart.xRot = (float)Math.toRadians(rotation.x);
                modelPart.yRot = (float)Math.toRadians(rotation.y);
                modelPart.zRot = (float)Math.toRadians(rotation.z);
            }
            if ((position = MountsOfMayhemModPlayerAnimationAPI.PlayerBone.interpolate(bone.positions, animationProgress)) != null) {
                modelPart.x += (float)position.x;
                modelPart.y -= (float)position.y;
                modelPart.z += (float)position.z;
            }
            if ((scale = MountsOfMayhemModPlayerAnimationAPI.PlayerBone.interpolate(bone.scales, animationProgress)) == null) continue;
            modelPart.xScale = (float)scale.x;
            modelPart.yScale = (float)scale.y;
            modelPart.zScale = (float)scale.z;
        }
        model.leftPants.copyFrom(model.leftLeg);
        model.rightPants.copyFrom(model.rightLeg);
        model.leftSleeve.copyFrom(model.leftArm);
        model.rightSleeve.copyFrom(model.rightArm);
        model.jacket.copyFrom(model.body);
        model.hat.copyFrom(model.head);
    }

    private void resetModelPose(PlayerModel<T> model) {
        model.leftLeg.setPos(1.9f, 12.0f, 0.0f);
        model.rightLeg.setPos(-1.9f, 12.0f, 0.0f);
        model.head.setPos(0.0f, 0.0f, 0.0f);
        model.rightArm.z = 0.0f;
        model.rightArm.x = -5.0f;
        model.leftArm.z = 0.0f;
        model.leftArm.x = 5.0f;
        model.body.xRot = 0.0f;
        model.rightLeg.z = 0.1f;
        model.leftLeg.z = 0.1f;
        model.rightLeg.y = 12.0f;
        model.leftLeg.y = 12.0f;
        model.head.y = 0.0f;
        model.head.zRot = 0.0f;
        model.body.y = 0.0f;
        model.body.x = 0.0f;
        model.body.z = 0.0f;
        model.body.yRot = 0.0f;
        model.body.zRot = 0.0f;
        model.head.xScale = 1.0f;
        model.head.yScale = 1.0f;
        model.head.zScale = 1.0f;
        model.body.xScale = 1.0f;
        model.body.yScale = 1.0f;
        model.body.zScale = 1.0f;
        model.rightArm.xScale = 1.0f;
        model.rightArm.yScale = 1.0f;
        model.rightArm.zScale = 1.0f;
        model.leftArm.xScale = 1.0f;
        model.leftArm.yScale = 1.0f;
        model.leftArm.zScale = 1.0f;
        model.rightLeg.xScale = 1.0f;
        model.rightLeg.yScale = 1.0f;
        model.rightLeg.zScale = 1.0f;
        model.leftLeg.xScale = 1.0f;
        model.leftLeg.yScale = 1.0f;
        model.leftLeg.zScale = 1.0f;
    }

    private ModelPart getModelPart(PlayerModel<T> model, String boneName) {
        switch (boneName) {
            case "torso": {
                return model.body;
            }
            case "head": {
                return model.head;
            }
            case "right_arm": {
                return model.rightArm;
            }
            case "left_arm": {
                return model.leftArm;
            }
            case "right_leg": {
                return model.rightLeg;
            }
            case "left_leg": {
                return model.leftLeg;
            }
        }
        return null;
    }
}

