/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.item;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class SpearItem
extends Item {
    private final int maxHoldTicks;
    private final int reloadTicks;
    private static final ResourceLocation AIM_SPEED_MOD_ID = ResourceLocation.parse((String)"mounts_of_mayhem:spear_aim_speed");

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks) {
        super(properties);
        this.maxHoldTicks = maxHoldTicks;
        this.reloadTicks = reloadTicks;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseDuration) {
        LivingEntity target;
        int elapsed;
        if (level.isClientSide) {
            return;
        }
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            player.stopUsingItem();
            return;
        }
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) == null) {
            move.addTransientModifier(new AttributeModifier(AIM_SPEED_MOD_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if ((elapsed = this.getUseDuration(stack, user) - remainingUseDuration) < 0) {
            elapsed = 0;
        }
        if (elapsed > 0 && (target = SpearItem.findTargetInFront(player, 5.0)) != null && target.isAlive()) {
            boolean moving;
            double speed = SpearItem.getMovementSpeed(player);
            float damage = SpearItem.computeDamage(speed);
            double dist = player.distanceTo((Entity)target);
            boolean inRange = dist <= 2.5;
            boolean bl = moving = speed >= 0.12;
            if (damage > 0.0f && inRange && moving) {
                target.hurt(level.damageSources().playerAttack(player), damage);
                Vec3 dir = player.getViewVector(1.0f);
                double kb = Math.min(0.5 + SpearItem.getMovementSpeed(player) * 1.0, 0.6);
                target.push(dir.x * kb, 0.08, dir.z * kb);
                EquipmentSlot slot = player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                stack.hurtAndBreak(1, (LivingEntity)player, slot);
                AttributeInstance moveAttr = player.getAttribute(Attributes.MOVEMENT_SPEED);
                if (moveAttr != null && moveAttr.getModifier(AIM_SPEED_MOD_ID) != null) {
                    moveAttr.removeModifier(AIM_SPEED_MOD_ID);
                }
                player.stopUsingItem();
                player.getCooldowns().addCooldown((Item)this, this.reloadTicks);
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        if (level.isClientSide) {
            return;
        }
        if (user instanceof Player) {
            AttributeInstance move;
            Player player = (Player)user;
            int elapsed = this.getUseDuration(stack, user) - timeLeft;
            if (elapsed >= this.maxHoldTicks) {
                player.getCooldowns().addCooldown((Item)this, this.reloadTicks);
            }
            if ((move = player.getAttribute(Attributes.MOVEMENT_SPEED)) != null && move.getModifier(AIM_SPEED_MOD_ID) != null) {
                move.removeModifier(AIM_SPEED_MOD_ID);
            }
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown((Item)this)) {
            return 0;
        }
        return this.maxHoldTicks;
    }

    protected static ItemAttributeModifiers createAttackAttributes(double attackDamage, double attackSpeed) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.parse((String)"mounts_of_mayhem:spear_attack_damage"), attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.parse((String)"mounts_of_mayhem:spear_attack_speed"), attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    private static double getMovementSpeed(Player player) {
        Vec3 v = player.getDeltaMovement();
        double base = v.length();
        if (player.isPassenger() && player.getVehicle() != null) {
            Entity vehicle = player.getVehicle();
            Vec3 vehicleVel = vehicle.getDeltaMovement();
            double vehicleSpeed = vehicleVel.length();
            base = vehicle instanceof AbstractHorse ? Math.max(base, vehicleSpeed * 1.55) : (vehicle instanceof Camel ? Math.max(base, vehicleSpeed * 1.45) : (vehicle instanceof AbstractMinecart ? Math.max(base, vehicleSpeed * 1.35) : (vehicle instanceof Boat ? Math.max(base, vehicleSpeed * 1.35) : (vehicle instanceof Phantom ? Math.max(base, vehicleSpeed * 2.05) : Math.max(base, vehicleSpeed * 1.35)))));
        }
        if (player.isPassenger() && base < 0.1) {
            base = 0.325;
        }
        return base;
    }

    private static LivingEntity findTargetInFront(Player player, double range) {
        Vec3 eye = player.getEyePosition(1.0f);
        Vec3 look = player.getViewVector(1.0f);
        Vec3 end = eye.add(look.scale(range));
        AABB box = new AABB(eye, end).inflate(0.5);
        List candidates = player.level().getEntities((Entity)player, box, e -> e instanceof LivingEntity && e != player);
        LivingEntity best = null;
        double bestDot = 0.9;
        for (Entity e2 : candidates) {
            Vec3 to = e2.position().add(0.0, (double)e2.getBbHeight() * 0.5, 0.0).subtract(eye).normalize();
            double dot = to.dot(look);
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            best = (LivingEntity)e2;
        }
        return best;
    }

    private static float computeDamage(double speed) {
        if (speed >= 0.35) {
            return 25.0f;
        }
        if (speed >= 0.25) {
            return 15.0f;
        }
        if (speed >= 0.15) {
            return 8.0f;
        }
        return 0.0f;
    }
}

