/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.init;

import net.gospi.mountsofmayhem.entity.NautilusEntity;
import net.gospi.mountsofmayhem.entity.ParchedEntity;
import net.gospi.mountsofmayhem.entity.ParchedEntityProjectile;
import net.gospi.mountsofmayhem.entity.ZombieNautilusEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MountsOfMayhemModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mounts_of_mayhem");
    public static final DeferredHolder<EntityType<?>, EntityType<NautilusEntity>> NAUTILUS = MountsOfMayhemModEntities.register("nautilus", EntityType.Builder.of(NautilusEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).sized(1.1f, 1.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<ZombieNautilusEntity>> ZOMBIE_NAUTILUS = MountsOfMayhemModEntities.register("zombie_nautilus", EntityType.Builder.of(ZombieNautilusEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).sized(1.1f, 1.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<ParchedEntity>> PARCHED = MountsOfMayhemModEntities.register("parched", EntityType.Builder.of(ParchedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ParchedEntityProjectile>> PARCHED_PROJECTILE = MountsOfMayhemModEntities.register("projectile_parched", EntityType.Builder.of(ParchedEntityProjectile::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        NautilusEntity.init(event);
        ZombieNautilusEntity.init(event);
        ParchedEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)NAUTILUS.get(), NautilusEntity.createAttributes().build());
        event.put((EntityType)ZOMBIE_NAUTILUS.get(), ZombieNautilusEntity.createAttributes().build());
        event.put((EntityType)PARCHED.get(), ParchedEntity.createAttributes().build());
    }
}

