/*
 * Decompiled with CFR 0.152.
 */
package mcmodparacordgems.item;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class EmeraldArmorItem
extends ArmorItem {
    public EmeraldArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 115;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{9, 12, 12, 9})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 12;
            }

            public SoundEvent getEquipSound() {
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("item.armor.equip_diamond"));
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.EMERALD)});
            }

            public String getName() {
                return "emerald_armor";
            }

            public float getToughness() {
                return 2.5f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends EmeraldArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "paracordgems:textures/models/armor/emeraldarmortexture1_layer_1.png";
        }
    }

    public static class Leggings
    extends EmeraldArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "paracordgems:textures/models/armor/emeraldarmortexture1_layer_2.png";
        }
    }

    public static class Chestplate
    extends EmeraldArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "paracordgems:textures/models/armor/emeraldarmortexture1_layer_1.png";
        }
    }

    public static class Helmet
    extends EmeraldArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "paracordgems:textures/models/armor/emeraldarmortexture1_layer_1.png";
        }
    }
}

