/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sw.block;

import net.mcreator.sw.init.SwModItems;
import net.mcreator.sw.procedures.HarmonyBedFeetBlockDestroyedByExplosionProcedure;
import net.mcreator.sw.procedures.HarmonyBedFeetBlockDestroyedByPlayerProcedure;
import net.mcreator.sw.procedures.HarmonyBedFeetOnBlockRightClickedProcedure;
import net.mcreator.sw.procedures.HarmonyBedFeetOnTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HarmonyBedFeetBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BedPart> BED_PART = BlockStateProperties.BED_PART;

    public HarmonyBedFeetBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).sound(SoundType.WOOD).strength(0.8f, 1.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(BED_PART, (Comparable)((BedPart)BED_PART.getValue("foot").get())));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)HarmonyBedFeetBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{HarmonyBedFeetBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), HarmonyBedFeetBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)HarmonyBedFeetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{HarmonyBedFeetBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), HarmonyBedFeetBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)HarmonyBedFeetBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{HarmonyBedFeetBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), HarmonyBedFeetBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)HarmonyBedFeetBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{HarmonyBedFeetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), HarmonyBedFeetBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BED_PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(BED_PART, (Comparable)((BedPart)BED_PART.getValue("foot").get()));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData, Player entity) {
        return new ItemStack((ItemLike)SwModItems.HARMONY_BEDITEM.get());
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        HarmonyBedFeetOnTickUpdateProcedure.execute((LevelAccessor)world);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        HarmonyBedFeetBlockDestroyedByPlayerProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        return retval;
    }

    public void wasExploded(ServerLevel world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        HarmonyBedFeetBlockDestroyedByExplosionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        HarmonyBedFeetOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

