/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.swbtm.entity;

import net.mcreator.swbtm.entity.EquestrianVillagerEntityProjectile;
import net.mcreator.swbtm.init.SwBtmModEntities;
import net.mcreator.swbtm.init.SwBtmModItems;
import net.mcreator.swbtm.procedures.EquestrianVillagerEntityDiesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class EquestrianVillagerEntity
extends Raider
implements RangedAttackMob {
    public static final EnumProxy<Raid.RaiderType> RAIDER_TYPE = new EnumProxy(Raid.RaiderType.class, new Object[]{SwBtmModEntities.EQUESTRIAN_VILLAGER, new int[]{0, 1, 2, 2, 2, 2, 3, 1}});

    public EquestrianVillagerEntity(EntityType<EquestrianVillagerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 8;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 10.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)SwBtmModItems.EQUESTRIANMAGIC.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.death"));
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EMPTY;
    }

    public void die(DamageSource source) {
        super.die(source);
        EquestrianVillagerEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        EquestrianVillagerEntityProjectile entityarrow = new EquestrianVillagerEntityProjectile((EntityType<? extends EquestrianVillagerEntityProjectile>)((EntityType)SwBtmModEntities.EQUESTRIAN_VILLAGER_PROJECTILE.get()), (LivingEntity)this, this.level());
        double d0 = target.getY() + (double)target.getEyeHeight() - 1.1;
        double d1 = target.getX() - this.getX();
        double d3 = target.getZ() - this.getZ();
        entityarrow.shoot(d1, d0 - entityarrow.getY() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.6f, 12.0f);
        this.level().addFreshEntity((Entity)entityarrow);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        EquestrianVillagerEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SwBtmModEntities.EQUESTRIAN_VILLAGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (EntitySpawnReason)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public void applyRaidBuffs(ServerLevel serverLevel, int num, boolean logic) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

