/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.upgradeMyDog;

import ketoshi.upgradeMyDog.commands.PetInfoCommand;
import ketoshi.upgradeMyDog.listeners.DogChestManager;
import ketoshi.upgradeMyDog.listeners.DogListener;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class UpgradeMyDog
extends JavaPlugin {
    private DogListener dogListener;
    private DogChestManager dogChestManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.dogListener = new DogListener(this);
        this.dogChestManager = new DogChestManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.dogListener, (Plugin)this);
        if (this.getConfig().getBoolean("chest-feature.enabled", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)this.dogChestManager, (Plugin)this);
            this.getLogger().info("Dog Chest feature has been enabled.");
        } else {
            this.getLogger().info("Dog Chest feature is disabled via config.");
        }
        this.getCommand("petinfo").setExecutor((CommandExecutor)new PetInfoCommand(this));
        this.getLogger().info("UpgradeMyDog has been successfully enabled!");
    }

    public void onDisable() {
        if (this.dogListener != null) {
            this.dogListener.savePetData();
        }
        if (this.dogChestManager != null && this.getConfig().getBoolean("chest-feature.enabled", true)) {
            this.dogChestManager.saveAllOpenChests();
        }
        this.getLogger().info("UpgradeMyDog has been disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("upgrademydog") && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("upgrademydog.reload")) {
                sender.sendMessage(this.dogListener.getMessage("no-permission"));
                return true;
            }
            this.reloadConfig();
            this.dogListener.loadConfigValues();
            if (this.getConfig().getBoolean("chest-feature.enabled", true)) {
                this.dogChestManager.loadConfigValues();
            }
            sender.sendMessage(this.dogListener.getMessage("plugin-reloaded"));
            return true;
        }
        return false;
    }

    public DogListener getDogListener() {
        return this.dogListener;
    }

    public DogChestManager getDogChestManager() {
        return this.dogChestManager;
    }
}

