/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.upgradeMyDog.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import ketoshi.upgradeMyDog.UpgradeMyDog;
import ketoshi.upgradeMyDog.listeners.DogChestManager;
import ketoshi.upgradeMyDog.listeners.DogListener;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PetInfoCommand
implements CommandExecutor {
    private final UpgradeMyDog plugin;
    private final DogListener dogListener;
    private final DogChestManager dogChestManager;
    private final Map<UUID, UUID> pendingRemovals = new HashMap<UUID, UUID>();

    public PetInfoCommand(UpgradeMyDog plugin) {
        this.plugin = plugin;
        this.dogListener = plugin.getDogListener();
        this.dogChestManager = plugin.getDogChestManager();
    }

    private String getMessage(String key, Map<String, String> replacements) {
        String message = this.plugin.getConfig().getString("messages." + key, "&cMissing message: " + key);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            message = message.replace(entry.getKey(), entry.getValue());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("command-only-for-players", Collections.emptyMap()));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 2 && args[0].equalsIgnoreCase("remove_confirm")) {
            return this.handleRemovalConfirmationRequest(player, args[1]);
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            return this.handleRemovalConfirmation(player);
        }
        return this.displayPetInfo(player);
    }

    private boolean displayPetInfo(Player player) {
        List<UUID> pets = this.dogListener.getPlayerPets(player.getUniqueId());
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("plugin-settings.prefix"));
        if (pets == null || pets.isEmpty()) {
            player.sendMessage(prefix + this.getMessage("no-pets-found", Collections.emptyMap()));
            return true;
        }
        player.sendMessage(prefix + this.getMessage("your-pets-header", Collections.emptyMap()));
        for (UUID petId : pets) {
            int level = this.dogListener.getPetLevel(petId);
            int damageLvl = this.dogListener.getDamageLevel(petId);
            int speedLvl = this.dogListener.getSpeedLevel(petId);
            String name = this.getMessage("pet-info-name", Collections.emptyMap());
            double currentMaxHealth = 20.0;
            double currentSpeed = 0.3;
            Entity petEntity = Bukkit.getEntity((UUID)petId);
            if (petEntity instanceof Wolf) {
                Wolf wolf = (Wolf)petEntity;
                name = wolf.getCustomName() != null ? ChatColor.stripColor((String)wolf.getCustomName()) : name;
                currentMaxHealth = Objects.requireNonNull(wolf.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getBaseValue();
                currentSpeed = Objects.requireNonNull(wolf.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)).getBaseValue();
            }
            TextComponent petLine = new TextComponent(String.valueOf(ChatColor.GRAY) + "- " + String.valueOf(ChatColor.YELLOW) + name + String.valueOf(ChatColor.GRAY) + " (Lvl " + level + ") ");
            TextComponent removeButton = new TextComponent(String.valueOf(ChatColor.RED) + "[-]");
            removeButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.getMessage("hover-remove-pet", Collections.emptyMap()))}));
            removeButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/petinfo remove_confirm " + petId.toString()));
            petLine.addExtra((BaseComponent)removeButton);
            player.spigot().sendMessage((BaseComponent)petLine);
            TextComponent healthComp = new TextComponent(this.getMessage("pet-info-health", Map.of("{value}", String.format("%.1f", currentMaxHealth))));
            healthComp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.getMessage("hover-health", Collections.emptyMap()))}));
            player.spigot().sendMessage((BaseComponent)healthComp);
            double damageBonus = this.plugin.getConfig().getDouble("upgrades.damage.bonus-per-level");
            double baseDamage = 4.0;
            double totalDamage = baseDamage + (double)damageLvl * damageBonus;
            TextComponent damageComp = new TextComponent(this.getMessage("pet-info-damage", Map.of("{value}", String.format("%.1f", totalDamage), "{level}", String.valueOf(damageLvl))));
            String damageItemName = this.plugin.getConfig().getString("upgrades.damage.upgrade-item").replace("_", " ").toLowerCase();
            damageComp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.getMessage("hover-damage", Map.of("{item_name}", damageItemName)))}));
            player.spigot().sendMessage((BaseComponent)damageComp);
            TextComponent speedComp = new TextComponent(this.getMessage("pet-info-speed", Map.of("{value}", String.format("%.3f", currentSpeed), "{level}", String.valueOf(speedLvl))));
            speedComp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.getMessage("hover-speed", Collections.emptyMap()))}));
            player.spigot().sendMessage((BaseComponent)speedComp);
            boolean hasChest = this.dogChestManager.hasChest(petId);
            TextComponent chestComp = new TextComponent(this.getMessage("pet-info-chest", Map.of("{value}", hasChest ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.GRAY) + "No")));
            String hoverText = hasChest ? this.getMessage("hover-chest-yes", Collections.emptyMap()) : this.getMessage("hover-chest-no", Map.of("{health}", String.valueOf(this.plugin.getConfig().getDouble("chest-feature.required-health"))));
            chestComp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)}));
            player.spigot().sendMessage((BaseComponent)chestComp);
            Location loc = this.dogListener.getLastLocation(petId);
            String locStr = loc != null ? "X:" + loc.getBlockX() + " Y:" + loc.getBlockY() + " Z:" + loc.getBlockZ() + " (" + loc.getWorld().getName() + ")" : this.getMessage("pet-info-location-unknown", Collections.emptyMap());
            player.sendMessage(this.getMessage("pet-info-location", Map.of("{value}", locStr)));
        }
        return true;
    }

    private boolean handleRemovalConfirmationRequest(final Player player, String petIdStr) {
        UUID petToRemoveId;
        try {
            petToRemoveId = UUID.fromString(petIdStr);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.dogListener.getMessage("removal-invalid-pet-id"));
            return true;
        }
        if (!this.dogListener.getPlayerPets(player.getUniqueId()).contains(petToRemoveId)) {
            player.sendMessage(this.dogListener.getMessage("removal-not-your-pet"));
            return true;
        }
        this.pendingRemovals.put(player.getUniqueId(), petToRemoveId);
        long timeout = this.plugin.getConfig().getLong("plugin-settings.pet-removal-confirmation-timeout", 30L);
        player.sendMessage(this.dogListener.getMessage("removal-confirmation-request").replace("{pet_id}", petIdStr).replace("{seconds}", String.valueOf(timeout)));
        new BukkitRunnable(this){
            final /* synthetic */ PetInfoCommand this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.this$0.pendingRemovals.getOrDefault(player.getUniqueId(), null) == petToRemoveId) {
                    this.this$0.pendingRemovals.remove(player.getUniqueId());
                    player.sendMessage(this.this$0.dogListener.getMessage("removal-request-cancelled"));
                }
            }
        }.runTaskLater((Plugin)this.plugin, 20L * timeout);
        return true;
    }

    private boolean handleRemovalConfirmation(Player player) {
        UUID petToRemoveId = this.pendingRemovals.remove(player.getUniqueId());
        if (petToRemoveId == null) {
            player.sendMessage(this.dogListener.getMessage("removal-no-pending-request"));
            return true;
        }
        this.dogListener.fullyRemovePet(petToRemoveId, player.getUniqueId());
        this.dogChestManager.removeChestData(petToRemoveId);
        player.sendMessage(this.dogListener.getMessage("removal-success"));
        Entity petEntity = Bukkit.getEntity((UUID)petToRemoveId);
        if (petEntity instanceof Wolf) {
            petEntity.remove();
            player.sendMessage(this.dogListener.getMessage("removal-entity-removed"));
        }
        return true;
    }
}

