/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.upgradeMyDog.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class DogChestManager
implements Listener {
    private final JavaPlugin plugin;
    private final File chestDataFile;
    private final FileConfiguration chestData;
    private final Map<UUID, Inventory> openChests = new HashMap<UUID, Inventory>();
    private String msgPrefix;
    private double requiredHealth;
    private int inventorySize;
    private String inventoryTitle;
    private Map<String, String> messages = new HashMap<String, String>();

    public DogChestManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.chestDataFile = new File(plugin.getDataFolder(), "dog_chests.yml");
        if (!this.chestDataFile.exists()) {
            try {
                plugin.getDataFolder().mkdirs();
                this.chestDataFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create dog_chests.yml!");
                e.printStackTrace();
            }
        }
        this.chestData = YamlConfiguration.loadConfiguration((File)this.chestDataFile);
        this.loadConfigValues();
    }

    public void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.msgPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("plugin-settings.prefix", "&7[&bUpgradeMyDog&7]&r "));
        this.requiredHealth = config.getDouble("chest-feature.required-health", 30.0);
        int size = config.getInt("chest-feature.inventory-size", 27);
        this.inventorySize = size > 0 && size % 9 == 0 ? size : 27;
        this.inventoryTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("chest-feature.inventory-title", "&1Dog's Storage"));
        this.messages.clear();
        if (config.isConfigurationSection("messages")) {
            for (String key : config.getConfigurationSection("messages").getKeys(false)) {
                this.messages.put(key, config.getString("messages." + key));
            }
        }
    }

    private String getMessage(String key) {
        return this.msgPrefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getOrDefault(key, "&cMissing message for key: " + key));
    }

    private void saveData() {
        try {
            this.chestData.save(this.chestDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save dog_chests.yml!");
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onDogInteract(PlayerInteractEntityEvent event) {
        Wolf wolf;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Wolf) || !(wolf = (Wolf)entity).isTamed()) {
            return;
        }
        Player player = event.getPlayer();
        if (wolf.getOwner() == null || !wolf.getOwner().getUniqueId().equals(player.getUniqueId())) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        UUID dogId = wolf.getUniqueId();
        String key = "dogs." + String.valueOf(dogId);
        if (!this.chestData.contains(key)) {
            if (player.getInventory().getItemInMainHand().getType() == Material.CHEST) {
                event.setCancelled(true);
                double maxHealth = Objects.requireNonNull(wolf.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getBaseValue();
                if (maxHealth >= this.requiredHealth) {
                    this.chestData.set(key + ".attached", (Object)true);
                    this.chestData.set(key + ".contents", new ArrayList());
                    this.saveData();
                    player.sendMessage(this.getMessage("chest-attached"));
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.CHEST, 1)});
                } else {
                    player.sendMessage(this.getMessage("chest-not-strong-enough").replace("{health}", String.valueOf(this.requiredHealth)));
                }
            }
        } else {
            event.setCancelled(true);
            Inventory inv = Bukkit.createInventory(null, (int)this.inventorySize, (String)this.inventoryTitle);
            List rawList = this.chestData.getList(key + ".contents");
            if (rawList != null) {
                for (int i = 0; i < rawList.size() && i < this.inventorySize; ++i) {
                    Object e = rawList.get(i);
                    if (!(e instanceof ItemStack)) continue;
                    ItemStack item = (ItemStack)e;
                    inv.setItem(i, item);
                }
            }
            this.openChests.put(dogId, inv);
            player.openInventory(inv);
            player.sendMessage(this.getMessage("chest-opened"));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inv = event.getInventory();
        UUID dogIdToRemove = null;
        for (Map.Entry<UUID, Inventory> entry : this.openChests.entrySet()) {
            if (entry.getValue() != inv) continue;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(inv.getContents()));
            this.chestData.set("dogs." + entry.getKey().toString() + ".contents", items);
            this.saveData();
            dogIdToRemove = entry.getKey();
            break;
        }
        if (dogIdToRemove != null) {
            this.openChests.remove(dogIdToRemove);
        }
    }

    @EventHandler
    public void onDogDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)livingEntity;
        UUID dogId = wolf.getUniqueId();
        String key = "dogs." + String.valueOf(dogId);
        if (this.chestData.contains(key)) {
            Player owner;
            List rawList = this.chestData.getList(key + ".contents");
            if (rawList != null) {
                for (Object obj : rawList) {
                    ItemStack item;
                    if (!(obj instanceof ItemStack) || (item = (ItemStack)obj) == null || item.getType() == Material.AIR) continue;
                    wolf.getWorld().dropItemNaturally(wolf.getLocation(), item);
                }
            }
            this.chestData.set("dogs." + String.valueOf(dogId), null);
            this.saveData();
            this.openChests.remove(dogId);
            AnimalTamer animalTamer = wolf.getOwner();
            if (animalTamer instanceof Player && (owner = (Player)animalTamer).isOnline()) {
                owner.sendMessage(this.getMessage("chest-dog-died"));
            }
        }
    }

    public void saveAllOpenChests() {
        if (this.openChests.isEmpty()) {
            return;
        }
        this.plugin.getLogger().info("Saving " + this.openChests.size() + " open dog chests...");
        for (Map.Entry<UUID, Inventory> entry : this.openChests.entrySet()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(entry.getValue().getContents()));
            this.chestData.set("dogs." + entry.getKey().toString() + ".contents", items);
        }
        this.saveData();
        this.openChests.clear();
    }

    public boolean hasChest(UUID petId) {
        return this.chestData.contains("dogs." + petId.toString());
    }

    public void removeChestData(UUID petId) {
        if (this.hasChest(petId)) {
            this.chestData.set("dogs." + petId.toString(), null);
            this.saveData();
        }
    }
}

