/*
 * Decompiled with CFR 0.152.
 */
package ketoshi.upgradeMyDog.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class DogListener
implements Listener {
    private final JavaPlugin plugin;
    private final File petsFile;
    private final FileConfiguration petsConfig;
    private final Map<UUID, Integer> petLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> petKills = new HashMap<UUID, Integer>();
    private final Map<UUID, List<UUID>> playerPets = new HashMap<UUID, List<UUID>>();
    private final Map<UUID, Integer> petSpeedLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> petSpeedProgress = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> petDamageLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> petDamageExp = new HashMap<UUID, Integer>();
    private final Map<UUID, Double> petMaxHealth = new HashMap<UUID, Double>();
    private final Map<UUID, Location> lastLocations = new HashMap<UUID, Location>();
    private final Map<UUID, UUID> pendingPetKills = new HashMap<UUID, UUID>();
    private final Set<UUID> recentlyNotified = new HashSet<UUID>();
    private String msgPrefix;
    private int maxPetsPerPlayer;
    private boolean preventFriendlyFire;
    private double baseMaxHealth;
    private double healthBonusPerLevel;
    private int killsForFirstLevel;
    private int killsMultiplierPerLevel;
    private Material damageUpgradeItem;
    private double damageBonusPerLevel;
    private int damageExpBaseReq;
    private int damageExpMultiplier;
    private int speedMaxLevel;
    private double speedBonusPerLevel;
    private Map<String, String> messages = new HashMap<String, String>();
    private boolean chestFeatureEnabled;
    private double chestRequiredHealth;

    public DogListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.petsFile = new File(plugin.getDataFolder(), "pets.yml");
        this.petsConfig = YamlConfiguration.loadConfiguration((File)this.petsFile);
        this.loadConfigValues();
        this.loadPetData();
    }

    public void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.msgPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("plugin-settings.prefix", "&7[&bUpgradeMyDog&7]&r "));
        this.maxPetsPerPlayer = config.getInt("plugin-settings.max-pets-per-player", 3);
        this.preventFriendlyFire = config.getBoolean("plugin-settings.prevent-friendly-fire", true);
        this.baseMaxHealth = config.getDouble("main-leveling.base-max-health", 20.0);
        this.healthBonusPerLevel = config.getDouble("main-leveling.health-bonus-per-level", 2.0);
        this.killsForFirstLevel = config.getInt("main-leveling.kills-for-first-level", 5);
        this.killsMultiplierPerLevel = config.getInt("main-leveling.kills-multiplier-per-level", 3);
        try {
            this.damageUpgradeItem = Material.valueOf((String)config.getString("upgrades.damage.upgrade-item", "COOKED_RABBIT").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material for damage upgrade item in config.yml. Defaulting to COOKED_RABBIT.");
            this.damageUpgradeItem = Material.COOKED_RABBIT;
        }
        this.damageBonusPerLevel = config.getDouble("upgrades.damage.bonus-per-level", 0.5);
        this.damageExpBaseReq = config.getInt("upgrades.damage.exp-base-requirement", 5);
        this.damageExpMultiplier = config.getInt("upgrades.damage.exp-requirement-multiplier", 3);
        this.speedMaxLevel = config.getInt("upgrades.speed.max-level", 7);
        this.speedBonusPerLevel = config.getDouble("upgrades.speed.bonus-per-level", 0.02);
        this.chestFeatureEnabled = config.getBoolean("chest-feature.enabled", true);
        this.chestRequiredHealth = config.getDouble("chest-feature.required-health", 30.0);
        this.messages.clear();
        if (config.isConfigurationSection("messages")) {
            for (String key : config.getConfigurationSection("messages").getKeys(false)) {
                this.messages.put(key, config.getString("messages." + key));
            }
        }
    }

    public String getMessage(String key) {
        return this.msgPrefix + ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getOrDefault(key, "&cMissing message for key: " + key));
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity victim;
        Wolf wolf;
        Entity entity = event.getDamager();
        if (entity instanceof Wolf && (wolf = (Wolf)entity).isTamed() && (entity = event.getEntity()) instanceof LivingEntity) {
            victim = (LivingEntity)entity;
            if (!(wolf.getOwner() instanceof Player)) {
                return;
            }
            UUID petId = wolf.getUniqueId();
            int level = this.petDamageLevels.getOrDefault(petId, 0);
            double extraDamage = (double)level * this.damageBonusPerLevel;
            event.setDamage(event.getDamage() + extraDamage);
            if (victim.getHealth() - event.getFinalDamage() <= 0.0) {
                this.pendingPetKills.put(victim.getUniqueId(), petId);
            }
        }
        if (this.preventFriendlyFire && (victim = event.getEntity()) instanceof Wolf && (wolf = (Wolf)victim).isTamed()) {
            Projectile projectile;
            UUID petId = wolf.getUniqueId();
            if (!this.petLevels.containsKey(petId)) {
                return;
            }
            Entity damager = event.getDamager();
            Player owner = (Player)wolf.getOwner();
            if (damager instanceof Player && damager.getUniqueId().equals(owner.getUniqueId())) {
                event.setCancelled(true);
            } else if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() instanceof Player && ((Player)projectile.getShooter()).getUniqueId().equals(owner.getUniqueId())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        Wolf wolf;
        LivingEntity level2;
        UUID victimId = event.getEntity().getUniqueId();
        if (this.pendingPetKills.containsKey(victimId)) {
            Player owner;
            Wolf wolf2;
            AnimalTamer animalTamer;
            UUID petId = this.pendingPetKills.remove(victimId);
            if (!this.petLevels.containsKey(petId)) {
                return;
            }
            int kills = this.petKills.getOrDefault(petId, 0) + 1;
            this.petKills.put(petId, kills);
            int level2 = this.petLevels.getOrDefault(petId, 1);
            int requiredKills = this.killsForFirstLevel + (level2 - 1) * this.killsMultiplierPerLevel;
            Entity petEntity = Bukkit.getEntity((UUID)petId);
            if (petEntity instanceof Wolf && (animalTamer = (wolf2 = (Wolf)petEntity).getOwner()) instanceof Player && (owner = (Player)animalTamer).isOnline()) {
                if (kills >= requiredKills) {
                    double newHealth;
                    double oldHealth = Objects.requireNonNull(wolf2.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getBaseValue();
                    this.petLevels.put(petId, ++level2);
                    this.petKills.put(petId, 0);
                    this.applyPetAttributes(wolf2);
                    wolf2.setHealth(wolf2.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                    owner.sendMessage(this.getMessage("pet-level-up").replace("{level}", String.valueOf(level2)));
                    wolf2.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, wolf2.getLocation().add(0.0, 1.0, 0.0), 15, 0.5, 0.5, 0.5);
                    wolf2.getWorld().playSound(wolf2.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                    if (this.chestFeatureEnabled && (newHealth = wolf2.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()) >= this.chestRequiredHealth && oldHealth < this.chestRequiredHealth) {
                        owner.sendMessage(this.getMessage("pet-now-strong-enough-for-chest").replace("{health}", String.valueOf(this.chestRequiredHealth)));
                    }
                } else {
                    owner.sendMessage(this.getMessage("kill-progress").replace("{kills}", String.valueOf(kills)).replace("{required_kills}", String.valueOf(requiredKills)));
                }
                this.savePetData();
            }
        }
        if ((level2 = event.getEntity()) instanceof Wolf && (wolf = (Wolf)level2).isTamed() && (level2 = wolf.getOwner()) instanceof Player) {
            Player owner = (Player)level2;
            UUID petId = wolf.getUniqueId();
            if (this.petLevels.containsKey(petId)) {
                this.removePetData(petId, owner.getUniqueId());
                this.savePetData();
                owner.sendMessage(this.getMessage("pet-died"));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTame(EntityTameEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Wolf) {
            Wolf wolf = (Wolf)livingEntity;
            livingEntity = event.getOwner();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                UUID playerId = player.getUniqueId();
                UUID petId = wolf.getUniqueId();
                List pets = this.playerPets.getOrDefault(playerId, new ArrayList());
                if (pets.size() >= this.maxPetsPerPlayer) {
                    player.sendMessage(this.getMessage("max-pets-reached").replace("{max_pets}", String.valueOf(this.maxPetsPerPlayer)));
                    event.setCancelled(true);
                    return;
                }
                ArrayList<UUID> mutablePets = new ArrayList<UUID>(pets);
                mutablePets.add(petId);
                this.playerPets.put(playerId, mutablePets);
                this.petLevels.put(petId, 1);
                this.petKills.put(petId, 0);
                this.petDamageLevels.put(petId, 0);
                this.petDamageExp.put(petId, 0);
                this.petSpeedLevels.put(petId, 0);
                this.petSpeedProgress.put(petId, 0);
                this.applyPetAttributes(wolf);
                player.sendMessage(this.getMessage("pet-tamed"));
                this.savePetData();
            }
        }
    }

    @EventHandler
    public void onPetDamageUpgrade(PlayerInteractEntityEvent event) {
        Player player;
        Wolf wolf;
        block8: {
            block7: {
                Entity entity = event.getRightClicked();
                if (!(entity instanceof Wolf) || !(wolf = (Wolf)entity).isTamed()) {
                    return;
                }
                AnimalTamer animalTamer = wolf.getOwner();
                if (!(animalTamer instanceof Player)) break block7;
                player = (Player)animalTamer;
                if (wolf.getOwner().getUniqueId().equals(event.getPlayer().getUniqueId())) break block8;
            }
            return;
        }
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        if (item.getType() != this.damageUpgradeItem) {
            return;
        }
        event.setCancelled(true);
        UUID petId = wolf.getUniqueId();
        int currentLevel = this.petDamageLevels.getOrDefault(petId, 0);
        int currentExp = this.petDamageExp.getOrDefault(petId, 0) + 1;
        int threshold = this.damageExpBaseReq + currentLevel * this.damageExpMultiplier;
        if (currentExp >= threshold) {
            this.petDamageLevels.put(petId, ++currentLevel);
            this.petDamageExp.put(petId, 0);
            player.sendMessage(this.getMessage("damage-level-up").replace("{level}", String.valueOf(currentLevel)));
            wolf.getWorld().playSound(wolf.getLocation(), Sound.ENTITY_IRON_GOLEM_REPAIR, 1.0f, 1.5f);
        } else {
            this.petDamageExp.put(petId, currentExp);
            player.sendMessage(this.getMessage("damage-progress").replace("{exp}", String.valueOf(currentExp)).replace("{required_exp}", String.valueOf(threshold)));
        }
        item.setAmount(item.getAmount() - 1);
        this.savePetData();
    }

    @EventHandler
    public void onPetSpeedUpgrade(PotionSplashEvent event) {
        boolean hasSpeed = event.getPotion().getEffects().stream().anyMatch(effect -> effect.getType().equals((Object)PotionEffectType.SPEED));
        if (!hasSpeed) {
            return;
        }
        for (LivingEntity entity : event.getAffectedEntities()) {
            int threshold;
            AnimalTamer animalTamer;
            Wolf wolf;
            if (!(entity instanceof Wolf) || !(wolf = (Wolf)entity).isTamed() || !((animalTamer = wolf.getOwner()) instanceof Player)) continue;
            Player owner = (Player)animalTamer;
            UUID petId = wolf.getUniqueId();
            int currentLevel = this.petSpeedLevels.getOrDefault(petId, 0);
            if (currentLevel >= this.speedMaxLevel) {
                if (this.recentlyNotified.contains(owner.getUniqueId())) continue;
                owner.sendMessage(this.getMessage("speed-max-level"));
                this.recentlyNotified.add(owner.getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentlyNotified.remove(owner.getUniqueId()), 40L);
                continue;
            }
            int progress = this.petSpeedProgress.getOrDefault(petId, 0) + 1;
            if (progress >= (threshold = (currentLevel + 1) * (currentLevel + 1))) {
                this.petSpeedLevels.put(petId, ++currentLevel);
                this.petSpeedProgress.put(petId, 0);
                this.applyPetAttributes(wolf);
                owner.sendMessage(this.getMessage("speed-level-up").replace("{level}", String.valueOf(currentLevel)));
                wolf.getWorld().playSound(wolf.getLocation(), Sound.ENTITY_WITCH_DRINK, 1.0f, 1.2f);
            } else {
                this.petSpeedProgress.put(petId, progress);
                owner.sendMessage(this.getMessage("speed-progress").replace("{progress}", String.valueOf(progress)).replace("{required_progress}", String.valueOf(threshold)));
            }
            this.savePetData();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWolfBreed(EntityBreedEvent event) {
        LivingEntity livingEntity;
        if (!(event.getEntity() instanceof Wolf) || !((livingEntity = event.getBreeder()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List pets = this.playerPets.getOrDefault(player.getUniqueId(), Collections.emptyList());
        if (pets.size() >= this.maxPetsPerPlayer) {
            event.setCancelled(true);
            if (!this.recentlyNotified.contains(player.getUniqueId())) {
                player.sendMessage(this.getMessage("cant-breed-max-pets").replace("{max_pets}", String.valueOf(this.maxPetsPerPlayer)));
                this.recentlyNotified.add(player.getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentlyNotified.remove(player.getUniqueId()), 40L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        List pets;
        Wolf babyWolf;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Wolf)) break block6;
                babyWolf = (Wolf)livingEntity;
                if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BREEDING) break block7;
            }
            return;
        }
        Player potentialOwner = null;
        for (Entity nearbyEntity : babyWolf.getNearbyEntities(5.0, 5.0, 5.0)) {
            Wolf parentWolf;
            if (!(nearbyEntity instanceof Wolf) || !(parentWolf = (Wolf)nearbyEntity).isTamed() || !(parentWolf.getOwner() instanceof Player)) continue;
            potentialOwner = (Player)parentWolf.getOwner();
            break;
        }
        if (potentialOwner != null && (pets = this.playerPets.getOrDefault(potentialOwner.getUniqueId(), Collections.emptyList())).size() >= this.maxPetsPerPlayer) {
            event.setCancelled(true);
            if (potentialOwner.isOnline()) {
                potentialOwner.sendMessage(this.getMessage("extra-puppy-removed").replace("{max_pets}", String.valueOf(this.maxPetsPerPlayer)));
            }
        }
    }

    @EventHandler
    public void onPlayerRebindPet(PlayerInteractEntityEvent event) {
        Wolf wolf;
        Player player;
        block8: {
            block7: {
                player = event.getPlayer();
                Entity entity = event.getRightClicked();
                if (!(entity instanceof Wolf)) break block7;
                wolf = (Wolf)entity;
                if (player.getInventory().getItemInMainHand().getType() == Material.BONE) break block8;
            }
            return;
        }
        if (!wolf.isTamed() || !wolf.getOwner().getUniqueId().equals(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        UUID petId = wolf.getUniqueId();
        if (this.petLevels.containsKey(petId)) {
            this.applyPetAttributes(wolf);
            player.sendMessage(this.getMessage("attributes-reapplied"));
        } else {
            List pets = this.playerPets.getOrDefault(player.getUniqueId(), new ArrayList());
            if (pets.size() >= this.maxPetsPerPlayer) {
                player.sendMessage(this.getMessage("rebind-failed-max-pets").replace("{max_pets}", String.valueOf(this.maxPetsPerPlayer)));
                return;
            }
            this.onTame(new EntityTameEvent((LivingEntity)wolf, (AnimalTamer)player));
        }
        wolf.getWorld().spawnParticle(Particle.HEART, wolf.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            Wolf wolf;
            if (!(entity instanceof Wolf) || !(wolf = (Wolf)entity).isTamed() || !this.petLevels.containsKey(wolf.getUniqueId())) continue;
            this.applyPetAttributes(wolf);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        player.getWorld().getEntitiesByClass(Wolf.class).stream().filter(Tameable::isTamed).filter(wolf -> wolf.getOwner() != null && player.getUniqueId().equals(wolf.getOwner().getUniqueId())).filter(wolf -> this.petLevels.containsKey(wolf.getUniqueId())).forEach(this::applyPetAttributes);
    }

    private void applyPetAttributes(Wolf wolf) {
        UUID petId = wolf.getUniqueId();
        int level = this.petLevels.getOrDefault(petId, 1);
        double newMaxHealth = this.baseMaxHealth + (double)(level - 1) * this.healthBonusPerLevel;
        this.petMaxHealth.put(petId, newMaxHealth);
        Objects.requireNonNull(wolf.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue(newMaxHealth);
        wolf.setHealth(newMaxHealth);
        int speedLevel = this.petSpeedLevels.getOrDefault(petId, 0);
        double baseSpeed = 0.3;
        double newSpeed = baseSpeed + (double)speedLevel * this.speedBonusPerLevel;
        Objects.requireNonNull(wolf.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)).setBaseValue(newSpeed);
        this.lastLocations.put(petId, wolf.getLocation());
    }

    private void removePetData(UUID petId, UUID ownerId) {
        this.petLevels.remove(petId);
        this.petKills.remove(petId);
        this.petSpeedLevels.remove(petId);
        this.petSpeedProgress.remove(petId);
        this.petDamageLevels.remove(petId);
        this.petDamageExp.remove(petId);
        this.petMaxHealth.remove(petId);
        this.lastLocations.remove(petId);
        List<UUID> ownerPets = this.playerPets.get(ownerId);
        if (ownerPets != null) {
            ArrayList<UUID> mutablePets = new ArrayList<UUID>(ownerPets);
            mutablePets.remove(petId);
            this.playerPets.put(ownerId, mutablePets);
        }
    }

    public void fullyRemovePet(UUID petId, UUID ownerId) {
        this.removePetData(petId, ownerId);
        this.savePetData();
    }

    public void savePetData() {
        for (String string : this.petsConfig.getKeys(false)) {
            this.petsConfig.set(string, null);
        }
        for (UUID uUID : this.petLevels.keySet()) {
            String path = "pets." + uUID.toString();
            this.petsConfig.set(path + ".level", (Object)this.petLevels.get(uUID));
            if (this.petKills.containsKey(uUID)) {
                this.petsConfig.set(path + ".kills", (Object)this.petKills.get(uUID));
            }
            if (this.petDamageLevels.containsKey(uUID)) {
                this.petsConfig.set(path + ".damageLevel", (Object)this.petDamageLevels.get(uUID));
            }
            if (this.petDamageExp.containsKey(uUID)) {
                this.petsConfig.set(path + ".damageExp", (Object)this.petDamageExp.get(uUID));
            }
            if (this.petSpeedLevels.containsKey(uUID)) {
                this.petsConfig.set(path + ".speedLevel", (Object)this.petSpeedLevels.get(uUID));
            }
            if (this.petSpeedProgress.containsKey(uUID)) {
                this.petsConfig.set(path + ".speedProgress", (Object)this.petSpeedProgress.get(uUID));
            }
            if (!this.petMaxHealth.containsKey(uUID)) continue;
            this.petsConfig.set(path + ".maxHealth", (Object)this.petMaxHealth.get(uUID));
        }
        for (Map.Entry entry : this.playerPets.entrySet()) {
            List<String> petIdStrings = ((List)entry.getValue()).stream().map(UUID::toString).toList();
            this.petsConfig.set("players." + ((UUID)entry.getKey()).toString() + ".pets", petIdStrings);
        }
        try {
            this.petsConfig.save(this.petsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save pets.yml!");
            e.printStackTrace();
        }
    }

    public void loadPetData() {
        if (!this.petsFile.exists()) {
            return;
        }
        this.petLevels.clear();
        this.petKills.clear();
        this.petDamageLevels.clear();
        this.petDamageExp.clear();
        this.petSpeedLevels.clear();
        this.petSpeedProgress.clear();
        this.petMaxHealth.clear();
        this.playerPets.clear();
        if (this.petsConfig.isConfigurationSection("pets")) {
            for (String petIdStr : this.petsConfig.getConfigurationSection("pets").getKeys(false)) {
                try {
                    UUID petId = UUID.fromString(petIdStr);
                    String path = "pets." + petIdStr;
                    this.petLevels.put(petId, this.petsConfig.getInt(path + ".level", 1));
                    this.petKills.put(petId, this.petsConfig.getInt(path + ".kills", 0));
                    this.petDamageLevels.put(petId, this.petsConfig.getInt(path + ".damageLevel", 0));
                    this.petDamageExp.put(petId, this.petsConfig.getInt(path + ".damageExp", 0));
                    this.petSpeedLevels.put(petId, this.petsConfig.getInt(path + ".speedLevel", 0));
                    this.petSpeedProgress.put(petId, this.petsConfig.getInt(path + ".speedProgress", 0));
                    this.petMaxHealth.put(petId, this.petsConfig.getDouble(path + ".maxHealth", this.baseMaxHealth));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Found invalid UUID in pets.yml: " + petIdStr);
                }
            }
        }
        if (this.petsConfig.isConfigurationSection("players")) {
            for (String playerIdStr : this.petsConfig.getConfigurationSection("players").getKeys(false)) {
                try {
                    UUID playerId = UUID.fromString(playerIdStr);
                    List petIdStrings = this.petsConfig.getStringList("players." + playerIdStr + ".pets");
                    List<UUID> petIds = petIdStrings.stream().map(UUID::fromString).toList();
                    this.playerPets.put(playerId, new ArrayList<UUID>(petIds));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Found invalid player UUID in pets.yml: " + playerIdStr);
                }
            }
        }
    }

    public List<UUID> getPlayerPets(UUID playerId) {
        return this.playerPets.getOrDefault(playerId, Collections.emptyList());
    }

    public int getPetLevel(UUID petId) {
        return this.petLevels.getOrDefault(petId, 1);
    }

    public int getDamageLevel(UUID petId) {
        return this.petDamageLevels.getOrDefault(petId, 0);
    }

    public int getSpeedLevel(UUID petId) {
        return this.petSpeedLevels.getOrDefault(petId, 0);
    }

    public Location getLastLocation(UUID petId) {
        return this.lastLocations.get(petId);
    }
}

