/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.List;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.entity.EntityPurger;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class PurgeAllEntitiesCommand
extends CoreCommand {
    private final EntityPurger entityPurger;

    @Inject
    PurgeAllEntitiesCommand(EntityPurger entityPurger) {
        this.entityPurger = entityPurger;
    }

    @Subcommand(value="purge-all-entities")
    @CommandPermission(value="multiverse.core.purgeall")
    @CommandCompletion(value="@mvworlds:scope=loaded|@spawncategories:multiple,resolveUntil=arg1 @spawncategories:multiple")
    @Syntax(value="[world] [spawn-categories]")
    void onPurgeAllEntitiesCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world, @Optional @Syntax(value="[spawn-categories]") SpawnCategory[] spawnCategories) {
        if (spawnCategories == null || spawnCategories.length == 0) {
            int purgeCount = this.entityPurger.purgeAllEntities(world);
            issuer.sendMessage("Successfully purged " + purgeCount + " entities in world " + world.getName() + ".");
            return;
        }
        int purgeCount = this.entityPurger.purgeEntities(world, spawnCategories);
        issuer.sendMessage("Successfully purged " + purgeCount + " entities in world " + world.getName() + " for spawn categories " + StringFormatter.join(List.of(spawnCategories), ", ") + ".");
    }
}

