/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.context.issueraware.PlayerArrayValue;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.UnsafeFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class TeleportCommand
extends CoreCommand {
    private final CoreConfig config;
    private final CorePermissionsChecker permissionsChecker;
    private final AsyncSafetyTeleporter safetyTeleporter;
    private final UnsafeFlags flags;

    @Inject
    TeleportCommand(@NotNull CoreConfig config, @NotNull CorePermissionsChecker permissionsChecker, @NotNull AsyncSafetyTeleporter safetyTeleporter, @NotNull UnsafeFlags flags) {
        this.config = config;
        this.permissionsChecker = permissionsChecker;
        this.safetyTeleporter = safetyTeleporter;
        this.flags = flags;
    }

    @CommandAlias(value="mvtp")
    @Subcommand(value="teleport|tp")
    @CommandPermission(value="@mvteleport")
    @CommandCompletion(value="@playersarray:checkPermissions=@mvteleportother|@destinations:byIssuerForArg=arg1 @destinations:notByIssuerForArg=arg1|@flags:byIssuerForArg=arg1,groupName=unsafe @flags:notByIssuerForArg=arg1,groupName=unsafe")
    @Syntax(value="[player] <destination> [--unsafe]")
    @Description(value="{@@mv-core.teleport.description}")
    void onTeleportCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[player]") @Description(value="{@@mv-core.teleport.player.description}") PlayerArrayValue playersValue, @Syntax(value="<destination>") @Description(value="{@@mv-core.teleport.destination.description}") DestinationInstance<?, ?> destination, @Optional @Syntax(value="[--unsafe]") @Description(value="") String[] flagArray) {
        Player[] players = playersValue.value();
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        if (players.length == 1) {
            this.teleportSinglePlayer(issuer, players[0], destination, parsedFlags);
        } else if (players.length > this.config.getConcurrentTeleportLimit()) {
            issuer.sendError((MessageKeyProvider)MVCorei18n.TELEPORT_TOOMANYPLAYERS, MessageReplacement.Replace.COUNT.with(this.config.getConcurrentTeleportLimit()));
        } else {
            this.teleportMultiplePlayers(issuer, players, destination, parsedFlags);
        }
    }

    private void teleportSinglePlayer(MVCommandIssuer issuer, Player player, DestinationInstance<?, ?> destination, ParsedCommandFlags parsedFlags) {
        if (!this.permissionsChecker.checkTeleportPermission(issuer.getIssuer(), (Entity)player, destination)) {
            issuer.sendMessage(player == issuer.getPlayer() ? "You do not have permission to teleport yourself!" : "You do not have permission to teleport other players!");
            return;
        }
        this.safetyTeleporter.to(destination).by(issuer).checkSafety(!parsedFlags.hasFlag(this.flags.unsafe) && destination.checkTeleportSafety()).passengerMode(this.config.getPassengerMode()).teleportSingle((Entity)player).onSuccess(() -> issuer.sendInfo((MessageKeyProvider)MVCorei18n.TELEPORT_SUCCESS, MessageReplacement.Replace.PLAYER.with(this.getYouOrName(issuer, player)), MessageReplacement.Replace.DESTINATION.with(destination.toString()))).onFailureCount(reasonsCountMap -> {
            for (Map.Entry entry : reasonsCountMap.entrySet()) {
                CoreLogging.finer("Failed to teleport %s players to %s: %s", entry.getValue(), destination, entry.getKey());
                issuer.sendError((MessageKeyProvider)MVCorei18n.TELEPORT_FAILED, MessageReplacement.Replace.PLAYER.with(player.getName()), MessageReplacement.Replace.DESTINATION.with(destination.toString()), MessageReplacement.Replace.REASON.with(Message.of((MessageKeyProvider)entry.getKey(), new MessageReplacement[0])));
            }
        });
    }

    private Message getYouOrName(MVCommandIssuer issuer, Player player) {
        return player == issuer.getPlayer() ? Message.of((MessageKeyProvider)MVCorei18n.GENERIC_YOU, new MessageReplacement[0]) : Message.of(player.getName(), new MessageReplacement[0]);
    }

    private void teleportMultiplePlayers(MVCommandIssuer issuer, Player[] players, DestinationInstance<?, ?> destination, ParsedCommandFlags parsedFlags) {
        if (!this.permissionsChecker.checkTeleportPermission(issuer.getIssuer(), Arrays.asList(players), destination)) {
            issuer.sendMessage("You do not have permission to teleport all these players!");
            return;
        }
        this.safetyTeleporter.to(destination).by(issuer).checkSafety(!parsedFlags.hasFlag(this.flags.unsafe) && destination.checkTeleportSafety()).passengerMode(this.config.getPassengerMode()).teleport(List.of(players)).onSuccessCount(successCount -> issuer.sendInfo((MessageKeyProvider)MVCorei18n.TELEPORT_SUCCESS, MessageReplacement.Replace.PLAYER.with(successCount + " players"), MessageReplacement.Replace.DESTINATION.with(destination.toString()))).onFailureCount(reasonsCountMap -> {
            for (Map.Entry entry : reasonsCountMap.entrySet()) {
                CoreLogging.finer("Failed to teleport %s players to %s: %s", entry.getValue(), destination, entry.getKey());
                issuer.sendError((MessageKeyProvider)MVCorei18n.TELEPORT_FAILED, MessageReplacement.Replace.PLAYER.with(String.valueOf(entry.getValue()) + " players"), MessageReplacement.Replace.DESTINATION.with(destination.toString()), MessageReplacement.Replace.REASON.with(Message.of((MessageKeyProvider)entry.getKey(), new MessageReplacement[0])));
            }
        });
    }
}

