/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.function.Consumer;
import org.bukkit.WorldBorder;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Default;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
@Subcommand(value="worldborder")
@CommandPermission(value="multiverse.core.worldborder")
final class WorldBorderCommand
extends CoreCommand {
    WorldBorderCommand() {
    }

    @Subcommand(value="add")
    void onWorldBorderAdd(MVCommandIssuer issuer, @Syntax(value="<size>") double size, @Optional @Default(value="0") @Syntax(value="[time]") int time, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> this.onWorldBorderSet(issuer, worldBorder.getSize() + size, time, world));
    }

    @Subcommand(value="center")
    void onWorldBorderCenter(MVCommandIssuer issuer, @Syntax(value="[x]") double x, @Syntax(value="[z]") double z, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> {
            if (worldBorder.getCenter().getX() == x && worldBorder.getCenter().getZ() == z) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_CENTER_NOTHINGCHANGED, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
                return;
            }
            worldBorder.setCenter(x, z);
            issuer.sendMessage(MVCorei18n.WORLDBORDER_CENTER_SUCCESS, MessageReplacement.replace("{x}").with(worldBorder.getCenter().getX()), MessageReplacement.replace("{z}").with(worldBorder.getCenter().getZ()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
        });
    }

    @Subcommand(value="damage amount")
    void onWorldBorderDamageAmount(MVCommandIssuer issuer, @Syntax(value="<damage>") double damage, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> {
            if (worldBorder.getDamageAmount() == damage) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_DAMAGEAMOUNT_NOTHINGCHANGED, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
                return;
            }
            worldBorder.setDamageAmount(damage);
            issuer.sendMessage(MVCorei18n.WORLDBORDER_DAMAGEAMOUNT_SUCCESS, MessageReplacement.replace("{amount}").with(worldBorder.getDamageAmount()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
        });
    }

    @Subcommand(value="damage buffer")
    void onWorldBorderDamageBuffer(MVCommandIssuer issuer, @Syntax(value="<distance>") double distance, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> {
            if (worldBorder.getDamageBuffer() == distance) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_DAMAGEBUFFER_NOTHINGCHANGED, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
                return;
            }
            worldBorder.setDamageBuffer(distance);
            issuer.sendMessage(MVCorei18n.WORLDBORDER_DAMAGEBUFFER_SUCCESS, MessageReplacement.replace("{distance}").with(worldBorder.getDamageBuffer()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
        });
    }

    @Subcommand(value="get")
    void onWorldBorderGet(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> issuer.sendMessage(MVCorei18n.WORLDBORDER_GET_SIZE, MessageReplacement.replace("{size}").with(worldBorder.getSize()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName())));
    }

    @Subcommand(value="set")
    void onWorldBorderSet(MVCommandIssuer issuer, @Syntax(value="<size>") double size, @Optional @Default(value="0") @Syntax(value="[time]") int time, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> {
            double previousSize = worldBorder.getSize();
            if (previousSize == size) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_SET_NOTHINGCHANGED, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
                return;
            }
            worldBorder.setSize(size, (long)time);
            if (time <= 0) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_SET_IMMEDIATE, MessageReplacement.replace("{size}").with(worldBorder.getSize()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
            } else {
                issuer.sendMessage(previousSize > size ? MVCorei18n.WORLDBORDER_SET_GROWING : MVCorei18n.WORLDBORDER_SET_SHRINKING, MessageReplacement.replace("{size}").with(size), MessageReplacement.replace("{time}").with(time), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
            }
        });
    }

    @Subcommand(value="warning distance")
    void onWorldBorderWarningDistance(MVCommandIssuer issuer, @Syntax(value="<distance>") int distance, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> {
            if (worldBorder.getWarningDistance() == distance) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_WARNINGDISTANCE_NOTHINGCHANGED, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
                return;
            }
            worldBorder.setWarningDistance(distance);
            issuer.sendMessage(MVCorei18n.WORLDBORDER_WARNINGDISTANCE_SUCCESS, MessageReplacement.replace("{distance}").with(worldBorder.getWarningDistance()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
        });
    }

    @Subcommand(value="warning time")
    void onWorldBorderWarningTime(MVCommandIssuer issuer, @Syntax(value="<time>") int time, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        this.worldBorderAction(issuer, world, worldBorder -> {
            if (worldBorder.getWarningTime() == time) {
                issuer.sendMessage(MVCorei18n.WORLDBORDER_WARNINGTIME_NOTHINGCHANGED, MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
                return;
            }
            worldBorder.setWarningTime(time);
            issuer.sendMessage(MVCorei18n.WORLDBORDER_WARNINGTIME_SUCCESS, MessageReplacement.replace("{time}").with(worldBorder.getWarningTime()), MessageReplacement.Replace.WORLD.with(world.getAliasOrName()));
        });
    }

    private void worldBorderAction(MVCommandIssuer issuer, LoadedMultiverseWorld world, Consumer<WorldBorder> worldBorderAction) {
        Try.run(() -> world.getWorldBorder().peek((Consumer)worldBorderAction)).onFailure(error -> issuer.sendError(error.getLocalizedMessage(), new MessageReplacement[0]));
    }
}

