/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.Collection;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.core.ExactDestinationInstance;
import org.mvplugins.multiverse.core.exceptions.utils.position.PositionParseException;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.position.EntityPosition;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class ExactDestination
implements Destination<ExactDestination, ExactDestinationInstance, InstanceFailureReason> {
    private final CoreConfig config;
    private final WorldManager worldManager;
    private final WorldEntryCheckerProvider worldEntryCheckerProvider;

    @Inject
    public ExactDestination(CoreConfig config, WorldManager worldManager, WorldEntryCheckerProvider worldEntryCheckerProvider) {
        this.config = config;
        this.worldManager = worldManager;
        this.worldEntryCheckerProvider = worldEntryCheckerProvider;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "e";
    }

    @NotNull
    public ExactDestinationInstance fromLocation(@NotNull Location location) {
        return new ExactDestinationInstance(this, location.getWorld().getName(), EntityPosition.ofLocation(location));
    }

    @Override
    @NotNull
    public Attempt<ExactDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull CommandSender sender, @NotNull String destinationParams) {
        EntityPosition position;
        String[] items = REPatterns.COLON.split(destinationParams, 2);
        if (items.length < 2) {
            if (items[0].equals("@here")) {
                return this.getLocationFromSender(sender).map(location -> Attempt.success(new ExactDestinationInstance(this, location.getWorld().getName(), EntityPosition.ofLocation(location)))).getOrElse(() -> Attempt.failure(InstanceFailureReason.INVALID_COORDINATES_FORMAT, new MessageReplacement[0]));
            }
            return Attempt.failure(InstanceFailureReason.INVALID_FORMAT, new MessageReplacement[0]);
        }
        String worldName = items[0];
        String positionStr = items[1];
        World world = (World)this.getLoadedMultiverseWorld(worldName).flatMap(LoadedMultiverseWorld::getBukkitWorld).getOrNull();
        if (world == null) {
            return Attempt.failure(InstanceFailureReason.WORLD_NOT_FOUND, MessageReplacement.Replace.WORLD.with(worldName));
        }
        try {
            position = EntityPosition.fromString(positionStr);
        }
        catch (PositionParseException e) {
            return Attempt.failure(InstanceFailureReason.INVALID_NUMBER_FORMAT, MessageReplacement.Replace.ERROR.with(e));
        }
        return Attempt.success(new ExactDestinationInstance(this, worldName, position));
    }

    private Option<LoadedMultiverseWorld> getLoadedMultiverseWorld(String worldName) {
        return this.config.getResolveAliasName() ? this.worldManager.getLoadedWorldByNameOrAlias(worldName) : this.worldManager.getLoadedWorld(worldName);
    }

    private Option<Location> getLocationFromSender(CommandSender sender) {
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return Option.of(entity.getLocation());
        }
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender blockSender = (BlockCommandSender)sender;
            return Option.of(blockSender.getBlock().getLocation());
        }
        return Option.none();
    }

    @Override
    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String destinationParams) {
        Stream<DestinationSuggestionPacket> stream = this.worldManager.getLoadedWorlds().stream().filter(world -> this.worldEntryCheckerProvider.forSender(sender).canAccessWorld((MultiverseWorld)world).isSuccess()).map(world -> new DestinationSuggestionPacket(this, world.getTabCompleteName() + ":", world.getName()));
        Location location = (Location)this.getLocationFromSender(sender).getOrNull();
        if (location != null) {
            DestinationSuggestionPacket herePacket = new DestinationSuggestionPacket(this, "@here", location.getWorld().getName());
            DestinationSuggestionPacket locationPacket = new DestinationSuggestionPacket(this, "%s:%.2f,%.2f,%.2f".formatted(location.getWorld().getName(), location.getX(), location.getY(), location.getZ()), location.getWorld().getName());
            DestinationSuggestionPacket locationPacketPW = new DestinationSuggestionPacket(this, "%s:%.2f,%.2f,%.2f:%.2f:%.2f".formatted(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw())), location.getWorld().getName());
            stream = Stream.concat(stream, Stream.of(herePacket, locationPacket, locationPacketPW));
        }
        return stream.toList();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        INVALID_FORMAT(MVCorei18n.DESTINATION_EXACT_FAILUREREASON_INVALIDFORMAT),
        INVALID_COORDINATES_FORMAT(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_INVALIDCOORDINATESFORMAT),
        INVALID_NUMBER_FORMAT(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_INVALIDNUMBERFORMAT),
        WORLD_NOT_FOUND(MVCorei18n.DESTINATION_SHARED_FAILUREREASON_WORLDNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        @Override
        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

