/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.inject;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import org.mvplugins.multiverse.core.inject.binder.PluginBinder;
import org.mvplugins.multiverse.external.glassfish.hk2.api.DynamicConfigurationService;
import org.mvplugins.multiverse.external.glassfish.hk2.api.MultiException;
import org.mvplugins.multiverse.external.glassfish.hk2.api.PopulatorPostProcessor;
import org.mvplugins.multiverse.external.glassfish.hk2.api.ServiceHandle;
import org.mvplugins.multiverse.external.glassfish.hk2.api.ServiceLocator;
import org.mvplugins.multiverse.external.glassfish.hk2.utilities.ClasspathDescriptorFileFinder;
import org.mvplugins.multiverse.external.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

public final class PluginServiceLocator {
    private final PluginBinder<?> pluginBinder;
    private final ServiceLocator serviceLocator;

    PluginServiceLocator(@NotNull PluginBinder<?> pluginBinder, @NotNull ServiceLocator serviceLocator) {
        this.pluginBinder = pluginBinder;
        this.serviceLocator = serviceLocator;
    }

    @NotNull
    public Try<PluginServiceLocator> enable() {
        return this.bindPlugin().flatMap(ignore -> this.populateServices()).flatMap(ignore -> this.injectPlugin()).mapTry(ignore -> this);
    }

    public void disable() {
        this.serviceLocator.preDestroy(this.pluginBinder.getPlugin());
    }

    @NotNull
    private Try<Void> bindPlugin() {
        return Try.of(() -> {
            ServiceLocatorUtilities.bind(this.serviceLocator, this.pluginBinder);
            return null;
        });
    }

    @NotNull
    private Try<Void> populateServices() {
        Object plugin = this.pluginBinder.getPlugin();
        return Try.of(() -> this.serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0])).mapTry(dynamicConfigurationService -> {
            dynamicConfigurationService.getPopulator().populate(new ClasspathDescriptorFileFinder(plugin.getClass().getClassLoader(), plugin.getName()), new PopulatorPostProcessor[0]);
            return null;
        });
    }

    @NotNull
    private Try<Void> injectPlugin() {
        return Try.of(() -> {
            this.serviceLocator.inject(this.pluginBinder.getPlugin());
            this.serviceLocator.postConstruct(this.pluginBinder.getPlugin());
            return null;
        });
    }

    @Nullable
    public <T> T getService(@NotNull Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.serviceLocator.getService(contractOrImpl, qualifiers);
    }

    @Nullable
    public <T> T getActiveService(@NotNull Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        ServiceHandle<T> handle = this.serviceLocator.getServiceHandle(contractOrImpl, qualifiers);
        if (handle != null && handle.isActive()) {
            return handle.getService();
        }
        return null;
    }

    @NotNull
    public <T> List<T> getAllServices(@NotNull Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        return this.serviceLocator.getAllServices(contractOrImpl, qualifiers);
    }

    @NotNull
    public <T> List<T> getAllActiveServices(@NotNull Class<T> contractOrImpl, Annotation ... qualifiers) throws MultiException {
        List<ServiceHandle<T>> handles = this.serviceLocator.getAllServiceHandles(contractOrImpl, qualifiers);
        return handles.stream().filter(ServiceHandle::isActive).map(ServiceHandle::getService).collect(Collectors.toList());
    }

    @NotNull
    ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }
}

