/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandCompletions;
import org.mvplugins.multiverse.core.command.MVCommandConditions;
import org.mvplugins.multiverse.core.command.MVCommandContexts;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.MVCommandPermissions;
import org.mvplugins.multiverse.core.command.MVDefaultExceptionHandler;
import org.mvplugins.multiverse.core.command.MVRootCommand;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.locale.PluginLocales;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.helpers.WorldNameChecker;
import org.mvplugins.multiverse.external.acf.commands.BaseCommand;
import org.mvplugins.multiverse.external.acf.commands.CommandHelp;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.HelpEntry;
import org.mvplugins.multiverse.external.acf.commands.LogLevel;
import org.mvplugins.multiverse.external.acf.commands.PaperCommandManager;
import org.mvplugins.multiverse.external.acf.commands.RootCommand;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public class MVCommandManager
extends PaperCommandManager {
    private final CommandFlagsManager flagsManager;
    private final CommandQueueManager commandQueueManager;
    private final Provider<MVCommandContexts> commandContextsProvider;
    private final Provider<MVCommandCompletions> commandCompletionsProvider;
    private final MVCommandPermissions commandPermissions;
    private final CoreConfig config;
    private final PluginLocales pluginLocales;

    @Inject
    MVCommandManager(@NotNull MultiverseCore plugin, @NotNull CommandFlagsManager flagsManager, @NotNull CommandQueueManager commandQueueManager, @NotNull Provider<MVCommandContexts> commandContextsProvider, @NotNull Provider<MVCommandCompletions> commandCompletionsProvider, @NotNull WorldManager worldManager, @NotNull WorldNameChecker worldNameChecker, @NotNull MVCommandPermissions commandPermissions, @NotNull CoreConfig config) {
        super((Plugin)plugin);
        this.flagsManager = flagsManager;
        this.commandQueueManager = commandQueueManager;
        this.commandContextsProvider = commandContextsProvider;
        this.commandCompletionsProvider = commandCompletionsProvider;
        this.commandPermissions = commandPermissions;
        this.config = config;
        this.pluginLocales = new PluginLocales(this);
        this.locales = this.pluginLocales;
        this.pluginLocales.loadLanguages();
        MVCommandConditions.load(this, worldManager, worldNameChecker);
        this.enableUnstableAPI("help");
        this.setDefaultExceptionHandler(new MVDefaultExceptionHandler());
    }

    public <T extends BaseCommand> void registerAllCommands(List<T> commands) {
        List<BaseCommand> noLegacy = commands.stream().filter(command -> !(command instanceof LegacyAliasCommand)).toList();
        if (!this.config.getShowLegacyAliases()) {
            noLegacy.forEach(this::registerCommand);
            return;
        }
        List<BaseCommand> legacy = commands.stream().filter(command -> command instanceof LegacyAliasCommand).toList();
        List<BaseCommand> noLegacyInheritance = noLegacy.stream().filter(command -> legacy.stream().noneMatch(legacyAliasCommand -> command.getClass().isAssignableFrom(legacyAliasCommand.getClass()))).toList();
        legacy.forEach(this::registerCommand);
        noLegacyInheritance.forEach(this::registerCommand);
    }

    @Override
    public void registerCommand(BaseCommand command, boolean force) {
        if (command instanceof LegacyAliasCommand && !this.config.getShowLegacyAliases()) {
            return;
        }
        super.registerCommand(command, force);
    }

    @Override
    public PluginLocales getLocales() {
        return this.pluginLocales;
    }

    @NotNull
    public synchronized CommandFlagsManager getFlagsManager() {
        return this.flagsManager;
    }

    @NotNull
    public synchronized CommandQueueManager getCommandQueueManager() {
        return this.commandQueueManager;
    }

    @NotNull
    public synchronized MVCommandPermissions getCommandPermissions() {
        return this.commandPermissions;
    }

    @NotNull
    public synchronized MVCommandContexts getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = this.commandContextsProvider.get();
        }
        return (MVCommandContexts)this.contexts;
    }

    @NotNull
    public synchronized MVCommandCompletions getCommandCompletions() {
        if (this.completions == null) {
            this.completions = this.commandCompletionsProvider.get();
        }
        return (MVCommandCompletions)this.completions;
    }

    @Override
    public boolean hasPermission(CommandIssuer issuer, String permission) {
        return this.commandPermissions.hasPermission(issuer, permission);
    }

    public void showUsage(@NotNull CommandHelp help) {
        List<HelpEntry> entries = help.getHelpEntries();
        if (entries.size() == 1) {
            this.getHelpFormatter().showDetailedHelp(help, entries.get(0));
            return;
        }
        help.showHelp();
    }

    @NotNull
    public MVCommandIssuer getConsoleCommandIssuer() {
        return this.getCommandIssuer(Bukkit.getConsoleSender());
    }

    @Override
    @NotNull
    public MVCommandIssuer getCommandIssuer(Object issuer) {
        if (!(issuer instanceof CommandSender)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Command Issuer.");
        }
        return new MVCommandIssuer(this, (CommandSender)issuer);
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new MVRootCommand(this, cmd);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        CoreLogging.finer("[%s] %s", new Object[]{level, message});
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

