/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.queue;

import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.data.type.CommandBlock;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.command.queue.ConfirmMode;
import org.mvplugins.multiverse.core.command.queue.RunQueuedFailedReason;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public class CommandQueueManager {
    private static final String CONSOLE_NAME = "@console";
    private static final String COMMAND_BLOCK_NAME = "@commandblock";
    private static final long TICKS_PER_SECOND = 20L;
    private final Plugin plugin;
    private final CoreConfig config;
    private final Map<String, CommandQueuePayload> queuedCommandMap;

    @Inject
    CommandQueueManager(@NotNull MultiverseCore plugin, @NotNull CoreConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.queuedCommandMap = new WeakHashMap<String, CommandQueuePayload>();
    }

    public void addToQueue(CommandQueuePayload payload) {
        String senderName = this.parseSenderName(payload.issuer());
        if (this.canRunImmediately(senderName)) {
            payload.action().run();
            return;
        }
        this.removeFromQueue(senderName);
        CoreLogging.finer("Add new command to queue for sender %s.", senderName);
        this.queuedCommandMap.put(senderName, payload);
        payload.expireTask(this.runExpireLater(senderName, this.config.getConfirmTimeout()));
        payload.issuer().sendInfo(payload.prompt());
        Object confirmCommand = "/mv confirm";
        if (this.config.getUseConfirmOtp()) {
            confirmCommand = (String)confirmCommand + " " + payload.otp();
        }
        payload.issuer().sendMessage(String.format("Run %s%s %sto continue. This will expire in %s seconds.", ChatColor.GREEN, confirmCommand, ChatColor.WHITE, this.config.getConfirmTimeout()));
    }

    private boolean canRunImmediately(@NotNull String senderName) {
        return switch (this.config.getConfirmMode()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfirmMode.ENABLE -> false;
            case ConfirmMode.PLAYER_ONLY -> {
                if (senderName.equals(CONSOLE_NAME) || senderName.equals(COMMAND_BLOCK_NAME)) {
                    yield true;
                }
                yield false;
            }
            case ConfirmMode.DISABLE_COMMAND_BLOCKS -> senderName.equals(COMMAND_BLOCK_NAME);
            case ConfirmMode.DISABLE_CONSOLE -> senderName.equals(CONSOLE_NAME);
            case ConfirmMode.DISABLE -> true;
        };
    }

    @NotNull
    private BukkitTask runExpireLater(@NotNull String senderName, int validDuration) {
        return Bukkit.getScheduler().runTaskLater(this.plugin, this.expireRunnable(senderName), (long)validDuration * 20L);
    }

    @NotNull
    private Runnable expireRunnable(@NotNull String senderName) {
        return () -> {
            CommandQueuePayload payload = this.queuedCommandMap.remove(senderName);
            if (payload == null) {
                return;
            }
            payload.issuer().sendMessage("Your queued command has expired.");
        };
    }

    public Attempt<Void, RunQueuedFailedReason> runQueuedCommand(@NotNull MVCommandIssuer issuer, String otpInput) {
        String senderName = this.parseSenderName(issuer);
        return Option.of(this.queuedCommandMap.get(senderName)).fold(() -> Attempt.failure(RunQueuedFailedReason.NO_COMMAND_IN_QUEUE, new MessageReplacement[0]), payload -> this.runPayload(senderName, otpInput, (CommandQueuePayload)payload));
    }

    private Attempt<Void, RunQueuedFailedReason> runPayload(String senderName, String otpInput, CommandQueuePayload payload) {
        if (this.config.getUseConfirmOtp() && !Objects.equals(payload.otp(), otpInput)) {
            return Attempt.failure(RunQueuedFailedReason.INVALID_OTP, MessageReplacement.replace("{otp}").with(otpInput));
        }
        this.removeFromQueue(senderName);
        CoreLogging.finer("Running queued command...", new Object[0]);
        payload.action().run();
        return Attempt.success(null);
    }

    public void removeFromQueue(@NotNull String senderName) {
        CommandQueuePayload payload = this.queuedCommandMap.remove(senderName);
        if (payload == null) {
            CoreLogging.finer("No queue command to remove for sender %s.", senderName);
            return;
        }
        Option.of(payload.expireTask()).peek(BukkitTask::cancel);
        CoreLogging.finer("Removed queue command for sender %s.", senderName);
    }

    private String parseSenderName(MVCommandIssuer issuer) {
        CommandSender sender = issuer.getIssuer();
        if (this.isCommandBlock(sender)) {
            return COMMAND_BLOCK_NAME;
        }
        if (sender instanceof ConsoleCommandSender) {
            return CONSOLE_NAME;
        }
        return sender.getName();
    }

    private boolean isCommandBlock(@NotNull CommandSender sender) {
        return sender instanceof BlockCommandSender && ((BlockCommandSender)sender).getBlock().getBlockData() instanceof CommandBlock;
    }
}

