/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.anchor.MultiverseAnchor;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class AnchorDeleteCommand
extends CoreCommand {
    private final AnchorManager anchorManager;

    @Inject
    AnchorDeleteCommand(@NotNull AnchorManager anchorManager) {
        this.anchorManager = anchorManager;
    }

    @Subcommand(value="anchor delete")
    @CommandPermission(value="multiverse.core.anchor.delete")
    @CommandCompletion(value="@anchornames")
    @Syntax(value="<name>")
    @Description(value="")
    void onAnchorDeleteCommand(MVCommandIssuer issuer, @Syntax(value="<name>") @Description(value="") MultiverseAnchor anchor) {
        if (this.anchorManager.deleteAnchor(anchor).isSuccess()) {
            issuer.sendMessage("&aAnchor &f" + anchor.getName() + "&a deleted.");
        } else {
            issuer.sendMessage("&cFailed to delete anchor.");
        }
    }
}

