/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.List;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.ListContentProvider;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class AnchorListCommand
extends CoreCommand {
    private final AnchorManager anchorManager;
    private final LocationManipulation locationManipulation;
    private final PageFilterFlags flags;

    @Inject
    AnchorListCommand(@NotNull AnchorManager anchorManager, @NotNull LocationManipulation locationManipulation, @NotNull PageFilterFlags flags) {
        this.anchorManager = anchorManager;
        this.locationManipulation = locationManipulation;
        this.flags = flags;
    }

    @Subcommand(value="anchor list")
    @CommandPermission(value="multiverse.core.anchor.list")
    @CommandCompletion(value="@flags:groupName=pagefilter")
    @Syntax(value="[--page <page>] [--filter <filter>]")
    @Description(value="")
    void onAnchorListCommand(MVCommandIssuer issuer, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") @Description(value="") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        ContentDisplay.create().addContent(ListContentProvider.forContent(this.getAnchors(issuer.getPlayer()))).withSendHandler((SendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader("&3==== [ Multiverse Anchors ] ====", new Object[0])).doPagination(true).withTargetPage(parsedFlags.flagValue(this.flags.page, 1)).withFilter(parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()))).send(issuer);
    }

    private List<String> getAnchors(Player player) {
        return this.anchorManager.getAnchors(player).stream().map(anchor -> "&a%s&7 - &f%s".formatted(anchor.getName(), this.locationManipulation.locationToString(anchor.getLocation()))).toList();
    }
}

