/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Default;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class ConfirmCommand
extends CoreCommand {
    @NotNull
    private final CommandQueueManager commandQueueManager;

    @Inject
    ConfirmCommand(@NotNull CommandQueueManager commandQueueManager) {
        this.commandQueueManager = commandQueueManager;
    }

    @Subcommand(value="confirm")
    @CommandPermission(value="multiverse.core.confirm")
    @Syntax(value="[otp]")
    @Description(value="{@@mv-core.confirm.description}")
    void onConfirmCommand(MVCommandIssuer issuer, @Default(value="0") String otp) {
        this.commandQueueManager.runQueuedCommand(issuer, otp).onFailure(failure -> issuer.sendError(failure.getFailureMessage()));
    }

    @Service
    private static final class LegacyAlias
    extends ConfirmCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull CommandQueueManager commandQueueCommand) {
            super(commandQueueCommand);
        }

        @Override
        @CommandAlias(value="mvconfirm")
        void onConfirmCommand(MVCommandIssuer issuer, String otp) {
            super.onConfirmCommand(issuer, otp);
        }
    }
}

