/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.RemovePlayerFlags;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.WorldTickDeferrer;
import org.mvplugins.multiverse.core.utils.result.AsyncAttemptsAggregate;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.helpers.PlayerWorldTeleporter;
import org.mvplugins.multiverse.core.world.options.DeleteWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class DeleteCommand
extends CoreCommand {
    private final CommandQueueManager commandQueueManager;
    private final WorldManager worldManager;
    private final PlayerWorldTeleporter playerWorldTeleporter;
    private final WorldTickDeferrer worldTickDeferrer;
    private final RemovePlayerFlags flags;

    @Inject
    DeleteCommand(@NotNull CommandQueueManager commandQueueManager, @NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull WorldTickDeferrer worldTickDeferrer, @NotNull RemovePlayerFlags flags) {
        this.commandQueueManager = commandQueueManager;
        this.worldManager = worldManager;
        this.playerWorldTeleporter = playerWorldTeleporter;
        this.worldTickDeferrer = worldTickDeferrer;
        this.flags = flags;
    }

    @Subcommand(value="delete")
    @CommandPermission(value="multiverse.core.delete")
    @CommandCompletion(value="@mvworlds:scope=both @flags:groupName=removeplayer")
    @Syntax(value="<world>")
    @Description(value="{@@mv-core.delete.description}")
    void onDeleteCommand(MVCommandIssuer issuer, @Single @Syntax(value="<world>") @Description(value="The world you want to delete.") MultiverseWorld world, @Optional @Syntax(value="[--remove-players]") @Description(value="") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer(issuer).action(() -> this.runDeleteCommand(issuer, world, parsedFlags)).prompt(Message.of((MessageKeyProvider)MVCorei18n.DELETE_PROMPT, "", MessageReplacement.Replace.WORLD.with(world.getName()))));
    }

    private void runDeleteCommand(MVCommandIssuer issuer, MultiverseWorld world, ParsedCommandFlags parsedFlags) {
        AsyncAttemptsAggregate<Object, Object> asyncAttemptsAggregate;
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.DELETE_DELETING, MessageReplacement.Replace.WORLD.with(world.getName()));
        if (parsedFlags.hasFlag(this.flags.removePlayers) && world.isLoaded() && world instanceof LoadedMultiverseWorld) {
            LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)world;
            asyncAttemptsAggregate = this.playerWorldTeleporter.removeFromWorld(loadedWorld);
        } else {
            asyncAttemptsAggregate = AsyncAttemptsAggregate.emptySuccess();
        }
        AsyncAttemptsAggregate future = asyncAttemptsAggregate;
        future.onSuccess(() -> this.worldTickDeferrer.deferWorldTick(() -> this.doWorldDeleting(issuer, world))).onFailure(() -> issuer.sendError("Failed to teleport one or more players out of the world!", new MessageReplacement[0]));
    }

    private void doWorldDeleting(MVCommandIssuer issuer, MultiverseWorld world) {
        this.worldManager.deleteWorld(DeleteWorldOptions.world(world)).onSuccess(deletedWorldName -> {
            CoreLogging.fine("World delete success: " + deletedWorldName, new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.DELETE_SUCCESS, MessageReplacement.Replace.WORLD.with(deletedWorldName));
        }).onFailure(failure -> {
            CoreLogging.fine("World delete failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class LegacyAlias
    extends DeleteCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull CommandQueueManager commandQueueManager, @NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull WorldTickDeferrer worldTickDeferrer, @NotNull RemovePlayerFlags flags) {
            super(commandQueueManager, worldManager, playerWorldTeleporter, worldTickDeferrer, flags);
        }

        @Override
        @CommandAlias(value="mvdelete")
        void onDeleteCommand(MVCommandIssuer issuer, MultiverseWorld world, String[] flags) {
            super.onDeleteCommand(issuer, world, flags);
        }
    }
}

