/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.bukkit.World;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.core.command.flag.FlagBuilder;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.core.world.options.ImportWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Conditions;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class ImportCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final Flags flags;

    @Inject
    ImportCommand(@NotNull WorldManager worldManager, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.flags = flags;
    }

    @Subcommand(value="import")
    @CommandPermission(value="multiverse.core.import")
    @CommandCompletion(value="@mvworlds:scope=potential @environments @flags:groupName=mvimport")
    @Syntax(value="<name> <environment> [--generator <generator[:id]> --adjust-spawn --biome <biome>]")
    @Description(value="{@@mv-core.import.description}")
    void onImportCommand(MVCommandIssuer issuer, @Conditions(value="worldname:scope=new") @Syntax(value="<name>") @Description(value="{@@mv-core.import.name.description}") String worldName, @Syntax(value="<env>") @Description(value="{@@mv-core.import.env.description}") World.Environment environment, @Optional @Syntax(value="[--generator <generator[:id]> --adjust-spawn --biome <biome>]") @Description(value="{@@mv-core.import.other.description}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.IMPORT_IMPORTING, MessageReplacement.Replace.WORLD.with(worldName));
        this.worldManager.importWorld(ImportWorldOptions.worldName(worldName).biome(parsedFlags.flagValue(this.flags.biome, "")).environment(environment).generator(parsedFlags.flagValue((CommandFlag)this.flags.generator, String.class)).useSpawnAdjust(!parsedFlags.hasFlag(this.flags.noAdjustSpawn)).doFolderCheck(!parsedFlags.hasFlag(this.flags.skipFolderCheck))).onSuccess(newWorld -> {
            CoreLogging.fine("World import success: " + String.valueOf(newWorld), new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.IMPORT_SUCCESS, MessageReplacement.Replace.WORLD.with(newWorld.getName()));
        }).onFailure(failure -> {
            CoreLogging.fine("World import failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class Flags
    extends FlagBuilder {
        private static final String NAME = "mvimport";
        private GeneratorProvider generatorProvider;
        private final CommandValueFlag<String> generator = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)((CommandValueFlag.Builder)CommandValueFlag.builder("--generator", String.class).addAlias("-g")).completion(input -> this.generatorProvider.suggestGeneratorString((String)input))).build());
        private final CommandFlag noAdjustSpawn = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-adjust-spawn").addAlias("-n")).build());
        private final CommandValueFlag<String> biome = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)CommandValueFlag.builder("--biome", String.class).addAlias("-b")).build());
        private final CommandFlag skipFolderCheck = this.flag(((CommandFlag.Builder)CommandFlag.builder("--skip-folder-check").addAlias("-f")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager, @NotNull GeneratorProvider generatorProvider) {
            super(NAME, flagsManager);
            this.generatorProvider = generatorProvider;
        }
    }

    @Service
    private static final class LegacyAlias
    extends ImportCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull Flags flags) {
            super(worldManager, flags);
        }

        @Override
        @CommandAlias(value="mvimport|mvim")
        void onImportCommand(MVCommandIssuer issuer, String worldName, World.Environment environment, String[] flags) {
            super.onImportCommand(issuer, worldName, environment, flags);
        }
    }
}

