/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Map;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.context.issueraware.MultiverseWorldValue;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.handle.PropertyModifyAction;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class ModifyCommand
extends CoreCommand {
    private static final Map<String, String> REMOVED_PROPERTIES = Map.of("animals", "/mv entity-spawn-config modify [world] animal set spawn <true|false>", "monsters", "/mv entity-spawn-config modify [world] monster set spawn <true|false>");
    private final WorldManager worldManager;

    @Inject
    ModifyCommand(WorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @Subcommand(value="modify")
    @CommandPermission(value="multiverse.core.modify")
    @CommandCompletion(value="@mvworlds:scope=both|@propsmodifyaction:byIssuerForArg=arg1 @propsmodifyaction:notByIssuerForArg=arg1|@mvworldpropsname:byIssuerForArg=arg1 @mvworldpropsname:notByIssuerForArg=arg1|@mvworldpropsvalue:byIssuerForArg=arg1 @mvworldpropsvalue:notByIssuerForArg=arg1")
    @Syntax(value="[world] <set|add|remove|reset> <property> [value]")
    @Description(value="{@@mv-core.modify.description}")
    void onModifyCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware,maxArgForAware=3") @Syntax(value="[world]") @Description(value="{@@mv-core.modify.world.description}") @NotNull MultiverseWorldValue worldValue, @Syntax(value="<set|add|remove|reset>") @Description(value="") @NotNull PropertyModifyAction action, @Syntax(value="<property>") @Description(value="{@@mv-core.modify.property.description}") @NotNull String propertyName, @Optional @Single @Syntax(value="[value]") @Description(value="{@@mv-core.modify.value.description}") @Nullable String propertyValue) {
        if (REMOVED_PROPERTIES.containsKey(propertyName)) {
            issuer.sendMessage(MVCorei18n.MODIFY_PROPERTYREMOVED, MessageReplacement.replace("{property}").with(propertyName), MessageReplacement.replace("{replacement}").with(REMOVED_PROPERTIES.get(propertyName)));
            return;
        }
        MultiverseWorld world = worldValue.value();
        if (action.isRequireValue() && propertyValue == null) {
            issuer.sendMessage(MVCorei18n.MODIFY_SPECIFYVALUE, MessageReplacement.replace("{action}").with(action.name().toLowerCase()), MessageReplacement.replace("{property}").with(propertyName));
            return;
        }
        if (!action.isRequireValue() && propertyValue != null) {
            issuer.sendMessage(MVCorei18n.MODIFY_CANNOTHAVEVALUE, MessageReplacement.replace("{action}").with(action.name().toLowerCase()), MessageReplacement.replace("{property}").with(propertyName));
            return;
        }
        StringPropertyHandle worldPropertyHandle = world.getStringPropertyHandle();
        worldPropertyHandle.modifyPropertyString(issuer.getIssuer(), propertyName, propertyValue, action).onSuccess(ignore -> {
            issuer.sendMessage(MVCorei18n.MODIFY_SUCCESS, MessageReplacement.replace("{action}").with(action.name().toLowerCase()), MessageReplacement.replace("{property}").with(propertyName), MessageReplacement.Replace.VALUE.with(worldPropertyHandle.getProperty(propertyName).getOrNull()), MessageReplacement.Replace.WORLD.with(world.getName()));
            this.worldManager.saveWorldsConfig();
        }).onFailure(exception -> {
            if (propertyValue == null) {
                issuer.sendMessage(MVCorei18n.MODIFY_FAILURE_NOVALUE, MessageReplacement.replace("{action}").with(action.name().toLowerCase()), MessageReplacement.replace("{property}").with(propertyName), MessageReplacement.Replace.WORLD.with(world.getName()), MessageReplacement.Replace.ERROR.with(exception.getMessage()));
            } else {
                issuer.sendMessage(MVCorei18n.MODIFY_FAILURE, MessageReplacement.replace("{action}").with(action.name().toLowerCase()), MessageReplacement.replace("{property}").with(propertyName), MessageReplacement.Replace.VALUE.with(propertyValue), MessageReplacement.Replace.WORLD.with(world.getName()), MessageReplacement.Replace.ERROR.with(exception.getMessage()));
            }
        });
    }

    @Service
    private static final class LegacyAlias
    extends ModifyCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(WorldManager worldManager) {
            super(worldManager);
        }

        @Override
        @CommandAlias(value="mvmodify|mvm")
        void onModifyCommand(MVCommandIssuer issuer, @NotNull MultiverseWorldValue world, @NotNull PropertyModifyAction action, @NotNull String propertyName, @Nullable String propertyValue) {
            super.onModifyCommand(issuer, world, action, propertyName, propertyValue);
        }
    }
}

