/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.RemovePlayerFlags;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.WorldTickDeferrer;
import org.mvplugins.multiverse.core.utils.result.AsyncAttemptsAggregate;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.helpers.PlayerWorldTeleporter;
import org.mvplugins.multiverse.core.world.options.RegenWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class RegenCommand
extends CoreCommand {
    @NotNull
    private final CommandQueueManager commandQueueManager;
    private final WorldManager worldManager;
    private final PlayerWorldTeleporter playerWorldTeleporter;
    private final WorldTickDeferrer worldTickDeferrer;
    private final Flags flags;

    @Inject
    RegenCommand(@NotNull CommandQueueManager commandQueueManager, @NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull WorldTickDeferrer worldTickDeferrer, @NotNull Flags flags) {
        this.commandQueueManager = commandQueueManager;
        this.worldManager = worldManager;
        this.playerWorldTeleporter = playerWorldTeleporter;
        this.worldTickDeferrer = worldTickDeferrer;
        this.flags = flags;
    }

    @Subcommand(value="regen")
    @CommandPermission(value="multiverse.core.regen")
    @CommandCompletion(value="@mvworlds:scope=loaded @flags:groupName=mvregen")
    @Syntax(value="<world> [--seed [seed] --reset-world-config --reset-gamerules --reset-world-border --remove-players]")
    @Description(value="{@@mv-core.regen.description}")
    void onRegenCommand(MVCommandIssuer issuer, @Syntax(value="<world>") @Description(value="{@@mv-core.regen.world.description}") LoadedMultiverseWorld world, @Optional @Syntax(value="[--seed [seed] --reset-world-config --reset-gamerules --reset-world-border --remove-players]") @Description(value="{@@mv-core.regen.other.description}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer(issuer).action(() -> this.runRegenCommand(issuer, world, parsedFlags)).prompt(Message.of((MessageKeyProvider)MVCorei18n.REGEN_PROMPT, "", MessageReplacement.Replace.WORLD.with(world.getName()))));
    }

    private void runRegenCommand(MVCommandIssuer issuer, LoadedMultiverseWorld world, ParsedCommandFlags parsedFlags) {
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.REGEN_REGENERATING, MessageReplacement.Replace.WORLD.with(world.getName()));
        List worldPlayers = world.getPlayers().getOrElse(Collections.emptyList());
        AsyncAttemptsAggregate future = parsedFlags.hasFlag(this.flags.removePlayers) ? this.playerWorldTeleporter.removeFromWorld(world) : AsyncAttemptsAggregate.emptySuccess();
        future.onSuccess(() -> this.worldTickDeferrer.deferWorldTick(() -> this.doWorldRegening(issuer, world, parsedFlags, worldPlayers))).onFailure(() -> issuer.sendError("Failed to teleport one or more players out of the world!", new MessageReplacement[0]));
    }

    private void doWorldRegening(MVCommandIssuer issuer, LoadedMultiverseWorld world, ParsedCommandFlags parsedFlags, List<Player> worldPlayers) {
        RegenWorldOptions regenWorldOptions = RegenWorldOptions.world(world).randomSeed(parsedFlags.hasFlag(this.flags.seed)).seed(parsedFlags.flagValue(this.flags.seed)).keepWorldConfig(!parsedFlags.hasFlag(this.flags.resetWorldConfig)).keepGameRule(!parsedFlags.hasFlag(this.flags.resetGamerules)).keepWorldBorder(!parsedFlags.hasFlag(this.flags.resetWorldBorder)).keepFiles(parsedFlags.flagValue(this.flags.keepFiles));
        this.worldManager.regenWorld(regenWorldOptions).onSuccess(newWorld -> {
            CoreLogging.fine("World regen success: " + String.valueOf(newWorld), new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.REGEN_SUCCESS, MessageReplacement.Replace.WORLD.with(newWorld.getName()));
            if (parsedFlags.hasFlag(this.flags.removePlayers)) {
                this.playerWorldTeleporter.teleportPlayersToWorld(worldPlayers, (MultiverseWorld)newWorld);
            }
        }).onFailure(failure -> {
            CoreLogging.warning("World regen failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class Flags
    extends RemovePlayerFlags {
        private static final String NAME = "mvregen";
        private final CommandValueFlag<String> seed = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)((CommandValueFlag.Builder)((CommandValueFlag.Builder)CommandValueFlag.builder("--seed", String.class).addAlias("-s")).completion(input -> Collections.singleton(String.valueOf(ACFUtil.RANDOM.nextLong())))).optional()).build());
        private final CommandFlag resetWorldConfig = this.flag(((CommandFlag.Builder)CommandFlag.builder("--reset-world-config").addAlias("-wc")).build());
        private final CommandFlag resetGamerules = this.flag(((CommandFlag.Builder)CommandFlag.builder("--reset-gamerules").addAlias("-gm")).build());
        private final CommandFlag resetWorldBorder = this.flag(((CommandFlag.Builder)CommandFlag.builder("--reset-world-border").addAlias("-wb")).build());
        private final CommandValueFlag<List> keepFiles = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)((CommandValueFlag.Builder)((CommandValueFlag.Builder)((CommandValueFlag.Builder)CommandValueFlag.builder("--keep-files", List.class).addAlias("-f")).completion(input -> List.of("paper-world.yml"))).defaultValue(Collections.emptyList())).context(input -> List.of(REPatterns.COMMA.split((CharSequence)input)))).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }

    @Service
    private static final class LegacyAlias
    extends RegenCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull CommandQueueManager commandQueueManager, @NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull WorldTickDeferrer worldTickDeferrer, @NotNull Flags flags) {
            super(commandQueueManager, worldManager, playerWorldTeleporter, worldTickDeferrer, flags);
        }

        @Override
        @CommandAlias(value="mvregen")
        void onRegenCommand(MVCommandIssuer issuer, LoadedMultiverseWorld world, String[] flags) {
            super.onRegenCommand(issuer, world, flags);
        }
    }
}

